/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.annotations.SessionAttribute;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Session;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class SessionAttributeWorker
implements ComponentClassTransformWorker2 {
    private final Request request;

    public SessionAttributeWorker(Request request) {
        this.request = request;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(SessionAttribute.class)) {
            this.convertFieldToSessionAccess(field);
        }
    }

    private void convertFieldToSessionAccess(PlasticField field) {
        SessionAttribute annotation = (SessionAttribute)field.getAnnotation(SessionAttribute.class);
        field.claim((Object)annotation);
        String key = this.determineSessionKey(field, annotation.value());
        field.setConduit((FieldConduit)new SessionKeyConduit(key));
    }

    private String determineSessionKey(PlasticField field, String value) {
        return value.equals("") ? field.getName() : value;
    }

    private class SessionKeyConduit
    implements FieldConduit<Object> {
        private final String key;

        public SessionKeyConduit(String key) {
            this.key = key;
        }

        public Object get(Object instance, InstanceContext context) {
            Session session = this.getSession();
            if (session == null) {
                return null;
            }
            return session.getAttribute(this.key);
        }

        public void set(Object instance, InstanceContext context, Object newValue) {
            SessionAttributeWorker.this.request.getSession(true).setAttribute(this.key, newValue);
        }

        private Session getSession() {
            return SessionAttributeWorker.this.request.getSession(false);
        }
    }
}

