/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorSettingsImpl;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationExecutorFactory {
    final List<ValidatorFactory> validatorFactories;
    private static final Logger log = LoggerFactory.getLogger(ValidationExecutorFactory.class);

    public ValidationExecutorFactory(ClassLoader classLoader) {
        this(ServiceLoader.load(ValidatorFactory.class, classLoader));
    }

    ValidationExecutorFactory(Iterable<ValidatorFactory> validatorFactoriesUnsorted) {
        Comparator<ValidatorFactory> rankingComparator = Comparator.comparingInt(ValidatorFactory::getServiceRanking).reversed();
        this.validatorFactories = new LinkedList<ValidatorFactory>();
        for (ValidatorFactory factory : validatorFactoriesUnsorted) {
            this.validatorFactories.add(factory);
        }
        Collections.sort(this.validatorFactories, rankingComparator);
    }

    @Nullable
    public ValidationExecutor createValidationExecutor(@NotNull ValidationContext context, boolean isSubPackage, boolean enforceSubpackageValidation, Map<String, ? extends ValidatorSettings> validatorSettingsById) {
        Map<String, Validator> validatorsById = this.createValidators(context, isSubPackage, enforceSubpackageValidation, validatorSettingsById != null ? validatorSettingsById : Collections.emptyMap());
        if (validatorsById.isEmpty()) {
            return null;
        }
        return new ValidationExecutor(validatorsById);
    }

    @NotNull
    private Map<String, Validator> createValidators(@NotNull ValidationContext context, boolean isSubPackage, boolean enforceSubpackageValidation, Map<String, ? extends ValidatorSettings> validatorSettingsById) {
        LinkedHashMap<String, Validator> validatorsById = new LinkedHashMap<String, Validator>();
        HashSet<String> validatorSettingsIds = new HashSet<String>(validatorSettingsById.keySet());
        for (ValidatorFactory validatorFactory : this.validatorFactories) {
            if (isSubPackage && !enforceSubpackageValidation && !validatorFactory.shouldValidateSubpackages()) continue;
            String validatorId = validatorFactory.getId();
            validatorSettingsIds.remove(validatorId);
            ValidatorSettings settings = validatorSettingsById.get(validatorId);
            if (settings == null) {
                settings = new ValidatorSettingsImpl();
            }
            if (!settings.isDisabled()) {
                try {
                    Validator oldValidator;
                    Validator validator = validatorFactory.createValidator(context, settings);
                    if (validator == null || (oldValidator = validatorsById.putIfAbsent(validatorId, validator)) == null) continue;
                    log.error("Found validators with duplicate id {}: {} and {} (Duplicate, not considered)", new Object[]{validatorId, oldValidator.getClass().getName(), validator.getClass().getName()});
                    continue;
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Could not create validator " + validatorId + " : " + e.getMessage(), e);
                }
            }
            log.debug("Skip disabled validator {}", (Object)validatorId);
        }
        if (!validatorSettingsIds.isEmpty() && !isSubPackage) {
            log.warn("There are validator settings bound to invalid ids {}", (Object)StringUtils.join(validatorSettingsIds, (String)", "));
        }
        return validatorsById;
    }
}

