/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.dynamicmedia;

import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

final class ImageProfileImpl
implements ImageProfile {
    static final String PN_CROP_TYPE = "crop_type";
    static final String CROP_TYPE_SMART = "crop_smart";
    static final String PN_BANNER = "banner";
    private final List<NamedDimension> smartCropDefinitions;

    ImageProfileImpl(@NotNull Resource profileResource) {
        this.smartCropDefinitions = ImageProfileImpl.readSmartCropDefinitions(profileResource);
    }

    @Override
    @NotNull
    public List<NamedDimension> getSmartCropDefinitions() {
        return this.smartCropDefinitions;
    }

    @NotNull
    private static List<NamedDimension> readSmartCropDefinitions(@NotNull Resource profileResource) {
        ArrayList<NamedDimension> result = new ArrayList<NamedDimension>();
        ValueMap props = profileResource.getValueMap();
        String cropType = (String)props.get(PN_CROP_TYPE, String.class);
        String cropDefs = (String)props.get(PN_BANNER, String.class);
        if (StringUtils.equals((CharSequence)cropType, (CharSequence)CROP_TYPE_SMART) && cropDefs != null) {
            String[] defs;
            for (String def : defs = StringUtils.split((String)cropDefs, (String)"|")) {
                String[] parts = StringUtils.split((String)def, (String)",");
                if (parts.length != 3) continue;
                try {
                    String name = parts[0];
                    long width = Long.parseLong(parts[1]);
                    long height = Long.parseLong(parts[2]);
                    result.add(new NamedDimension(name, width, height));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

