/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core.commands;

import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetOsgiFrameworkProperty
implements CrankstartCommand {
    public static final String I_OSGI_PROPERTY = "osgi.property";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_OSGI_PROPERTY.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "osgi.property: set an OSGi property";
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine cmd) throws Exception {
        String args = cmd.getQualifier();
        String[] parts = args.split(" ");
        if (parts.length != 2) {
            this.log.warn("Invalid OSGi property statement, ignored: [{}]", (Object)cmd);
            return;
        }
        String key = parts[0].trim();
        String value = parts[1].trim();
        this.log.info("Setting OSGI property {}={}", (Object)key, (Object)value);
        crankstartContext.setOsgiFrameworkProperty(key, value);
    }
}

