/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.logservice.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JSupport
implements LogListener {
    private static final String COMPONENT_NAME = "component.name";
    private static final String LOGGER_EVENT_FRAMEWORK = "Events.Framework";
    private static final String LOGGER_EVENT_BUNDLE = "Events.Bundle";
    private static final String LOGGER_EVENT_SERVICE = "Events.Service";
    private static final String LOGGER_EVENT_LOG_SERVICE = "LogService";
    private static final String SL_MARKER = "STARTLEVEL CHANGED";
    private final FrameworkStartLevel startLevel;
    private final List<String> logServiceLoggers = Arrays.asList("Events.Framework", "Events.Bundle", "Events.Service", "LogService");

    public SLF4JSupport(FrameworkStartLevel startLevel) {
        this.startLevel = startLevel;
    }

    public void logged(LogEntry logEntry) {
        this.doLog(logEntry);
    }

    private void doLog(LogEntry logEntry) {
        boolean isLogService = this.logServiceLoggers.contains(logEntry.getLoggerName());
        Logger logger = LoggerFactory.getLogger((String)(isLogService ? this.getLoggerName(logEntry.getBundle()) : logEntry.getLoggerName()));
        if (!SLF4JSupport.isEnabled(logger, logEntry)) {
            return;
        }
        this.logOut(logger, logEntry);
    }

    private String getLoggerName(Bundle bundle) {
        String name;
        if (bundle == null) {
            name = "system.bundle";
        } else {
            name = bundle.getSymbolicName();
            if (name == null) {
                name = bundle.getLocation();
            }
            if (name == null) {
                name = String.valueOf(bundle.getBundleId());
            }
        }
        return name;
    }

    private synchronized void logOut(Logger logger, LogEntry logEntry) {
        Throwable exception;
        StringBuilder msg = new StringBuilder();
        ServiceReference sr = logEntry.getServiceReference();
        if (sr != null) {
            msg.append("Service [");
            if (sr.getProperty("service.pid") != null) {
                msg.append(sr.getProperty("service.pid")).append(',');
            } else if (sr.getProperty(COMPONENT_NAME) != null) {
                msg.append(sr.getProperty(COMPONENT_NAME)).append(',');
            } else if (sr.getProperty("service.description") != null) {
                msg.append(sr.getProperty("service.description")).append(',');
            }
            msg.append(sr.getProperty("service.id")).append(", ").append(Arrays.toString((String[])sr.getProperty("objectClass"))).append("] ");
        }
        if (logEntry.getMessage() != null) {
            msg.append(logEntry.getMessage());
            if (LOGGER_EVENT_FRAMEWORK.equals(logEntry.getLoggerName()) && logEntry.getMessage().contains(SL_MARKER)) {
                msg.append(" to ");
                msg.append(String.valueOf(this.startLevel.getStartLevel()));
            }
        }
        if ((exception = logEntry.getException()) != null) {
            msg.append(" (").append(exception).append(')');
        }
        String message = msg.toString();
        switch (logEntry.getLogLevel()) {
            case DEBUG: {
                logger.debug(message, exception);
                break;
            }
            case INFO: {
                logger.info(message, exception);
                break;
            }
            case WARN: {
                logger.warn(message, exception);
                break;
            }
            case ERROR: {
                logger.error(message, exception);
                break;
            }
            case TRACE: {
                logger.trace(message, exception);
                break;
            }
            case AUDIT: {
                logger.trace(message, exception);
            }
        }
    }

    static boolean isEnabled(Logger logger, LogEntry logEntry) {
        switch (logEntry.getLogLevel()) {
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case AUDIT: {
                return logger.isTraceEnabled();
            }
        }
        return false;
    }

    public synchronized void replay(Enumeration<LogEntry> log) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>(Collections.list(log));
        Collections.reverse(entries);
        for (LogEntry entry : entries) {
            this.doLog(entry);
        }
    }
}

