/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.client.mcp.common.constants;

/**
 * openApi constants.
 */
public class OpenApiConstants {

    /**
     * the version of openApi key.
     */
    public static final String OPEN_API_VERSION_KEY = "openapi";

    /**
     * the info of openApi key.
     */
    public static final String OPEN_API_INFO_KEY = "info";

    /**
     * the title of info key.
     */
    public static final String OPEN_API_INFO_TITLE_KEY = "title";

    /**
     * the description of info key.
     */
    public static final String OPEN_API_INFO_DESCRIPTION_KEY = "description";

    /**
     * the version of info key.
     */
    public static final String OPEN_API_INFO_VERSION_KEY = "version";

    /**
     * the server of openApi key.
     */
    public static final String OPEN_API_SERVER_KEY = "server";

    /**
     * the url of openApi server.
     */
    public static final String OPEN_API_SERVER_URL_KEY = "url";

    /**
     * the path of openApi key.
     */
    public static final String OPEN_API_PATH_KEY = "paths";

    /**
     * the summary of method key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_SUMMARY_KEY = "summary";

    /**
     * the description of method key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_DESCRIPTION_KEY = "description";

    /**
     * the operationId of method key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_OPERATION_ID_KEY = "operationId";

    /**
     * the tag of method key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_TAG_KEY = "tag";

    /**
     * the parameters of method key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_PARAMETERS_KEY = "parameters";

    /**
     * the name of parameter key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_PARAMETERS_NAME_KEY = "name";

    /**
     * the location of parameter key.
     */
    public static final String OPEN_API_OPERATION_PATH_METHOD_PARAMETERS_IN_KEY = "in";

    /**
     * the description of parameter key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_PARAMETERS_DESCRIPTION_KEY = "description";

    /**
     * the required of parameter key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_PARAMETERS_REQUIRED_KEY = "required";

    /**
     * the schema of parameter key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_PARAMETERS_SCHEMA_KEY = "schema";

    /**
     * the type of schema key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_PARAMETERS_SCHEMA_TYPE_KEY = "type";

    /**
     * the defaultValue of schema key.
     */
    public static final String OPEN_API_PATH_OPERATION_METHOD_PARAMETERS_SCHEMA_DEFAULT_VALUE_KEY = "defaultValue";
}
