/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal.http;

import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.apache.pulsar.client.admin.internal.http.AsyncHttpConnector;
import org.apache.pulsar.client.impl.PulsarClientSharedResourcesImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class AsyncHttpConnectorProvider
implements ConnectorProvider {
    private final ClientConfigurationData conf;
    private Connector connector;
    private final int autoCertRefreshTimeSeconds;
    private final boolean acceptGzipCompression;

    public AsyncHttpConnectorProvider(ClientConfigurationData conf, int autoCertRefreshTimeSeconds, boolean acceptGzipCompression) {
        this.conf = conf;
        this.autoCertRefreshTimeSeconds = autoCertRefreshTimeSeconds;
        this.acceptGzipCompression = acceptGzipCompression;
    }

    public Connector getConnector(Client client, Configuration runtimeConfig) {
        if (this.connector == null) {
            this.connector = new AsyncHttpConnector(client, this.conf, this.autoCertRefreshTimeSeconds, this.acceptGzipCompression);
        }
        return this.connector;
    }

    public AsyncHttpConnector getConnector(int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs, int autoCertRefreshTimeSeconds, PulsarClientSharedResourcesImpl sharedResources) {
        return new AsyncHttpConnector(connectTimeoutMs, readTimeoutMs, requestTimeoutMs, autoCertRefreshTimeSeconds, this.conf, this.acceptGzipCompression, sharedResources);
    }
}

