/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.provider.annotation;

import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;

public class CsdlConstantExpression
extends CsdlExpression {
    private final ConstantExpressionType type;
    private String value;

    public CsdlConstantExpression(ConstantExpressionType type) {
        this.type = type;
    }

    public CsdlConstantExpression(ConstantExpressionType type, String value) {
        this.type = type;
        this.value = value;
    }

    public ConstantExpressionType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public CsdlConstantExpression setValue(String value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsdlConstantExpression)) {
            return false;
        }
        CsdlConstantExpression csdlConstExp = (CsdlConstantExpression)obj;
        return (this.getValue() == null ? csdlConstExp.getValue() == null : this.getValue().equals(csdlConstExp.getValue())) && (this.getType() == null ? csdlConstExp.getType() == null : this.getType().equals((Object)csdlConstExp.getType()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public static enum ConstantExpressionType {
        Binary,
        Bool,
        Date,
        DateTimeOffset,
        Decimal,
        Duration,
        EnumMember,
        Float,
        Guid,
        Int,
        String,
        TimeOfDay;


        public static ConstantExpressionType fromString(String value) {
            ConstantExpressionType result = null;
            try {
                result = ConstantExpressionType.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return result;
        }
    }
}

