/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.el.unified.FacesELContext;
import org.apache.myfaces.util.Purgeable;

public abstract class FacesContextImplBase
extends FacesContext
implements Purgeable {
    private Application _application;
    private ExternalContext _externalContext;
    private ReleaseableExternalContext _defaultExternalContext;
    private UIViewRoot _viewRoot;
    private RenderKitFactory _renderKitFactory;
    private ELContext _elContext;
    private Map<Object, Object> _attributes = null;
    private boolean _processingEvents = true;
    private ExceptionHandler _exceptionHandler = null;
    private RenderKit _cachedRenderKit = null;
    private String _cachedRenderKitId = null;
    protected boolean _released = false;
    private ApplicationFactory _applicationFactory = null;
    private List<String> _resourceLibraryContracts;
    private Character _separatorChar;
    private FacesContext _currentFacesContext;

    public FacesContextImplBase(ExternalContext externalContext, ReleaseableExternalContext defaultExternalContext) {
        this._externalContext = externalContext;
        this._defaultExternalContext = defaultExternalContext;
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public FacesContextImplBase(ExternalContext externalContext, ReleaseableExternalContext defaultExternalContext, ApplicationFactory applicationFactory, RenderKitFactory renderKitFactory) {
        this._externalContext = externalContext;
        this._defaultExternalContext = defaultExternalContext;
        this._applicationFactory = applicationFactory;
        this._renderKitFactory = renderKitFactory;
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public void release() {
        this._applicationFactory = null;
        this._currentFacesContext = null;
        if (this._defaultExternalContext != null) {
            this._defaultExternalContext.release();
            this._defaultExternalContext = null;
        }
        this._application = null;
        this._externalContext = null;
        this._viewRoot = null;
        this._renderKitFactory = null;
        this._elContext = null;
        this._exceptionHandler = null;
        this._cachedRenderKit = null;
        this._cachedRenderKitId = null;
        this._separatorChar = null;
        if (this._attributes != null) {
            this._attributes.clear();
            this._attributes = null;
        }
        this._released = true;
        FacesContext.setCurrentInstance(null);
    }

    public boolean isReleased() {
        return this._released;
    }

    public final ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this._externalContext;
    }

    public final Application getApplication() {
        this.assertNotReleased();
        if (this._application == null) {
            if (this._applicationFactory == null) {
                this._applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            }
            this._application = this._applicationFactory.getApplication();
        }
        return this._application;
    }

    @Override
    public void purge() {
        this._application = null;
        this._renderKitFactory = null;
        this._cachedRenderKit = null;
        this._cachedRenderKitId = null;
    }

    public final ExceptionHandler getExceptionHandler() {
        this.assertNotReleased();
        return this._exceptionHandler;
    }

    public final void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.assertNotReleased();
        this._exceptionHandler = exceptionHandler;
    }

    public final boolean isProcessingEvents() {
        this.assertNotReleased();
        return this._processingEvents;
    }

    public final void setProcessingEvents(boolean processingEvents) {
        this.assertNotReleased();
        this._processingEvents = processingEvents;
    }

    public final ELContext getELContext() {
        this.assertNotReleased();
        if (this._elContext != null) {
            return this._elContext;
        }
        this._elContext = new FacesELContext(this.getApplication().getELResolver(), this.getCurrentFacesContext());
        ELContextEvent event = new ELContextEvent(this._elContext);
        for (ELContextListener listener : this.getApplication().getELContextListeners()) {
            listener.contextCreated(event);
        }
        return this._elContext;
    }

    public final Map<Object, Object> getAttributes() {
        this.assertNotReleased();
        if (this._attributes == null) {
            this._attributes = new HashMap<Object, Object>();
        }
        return this._attributes;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this._viewRoot;
    }

    public final void setViewRoot(UIViewRoot viewRoot) {
        Map viewMap;
        this.assertNotReleased();
        if (viewRoot == null) {
            throw new NullPointerException("viewRoot");
        }
        if (this._viewRoot != null && !this._viewRoot.equals(viewRoot) && !Boolean.TRUE.equals(this.getAttributes().get("org.apache.myfaces.BUILDING_VIEW_METADATA")) && (viewMap = this._viewRoot.getViewMap(false)) != null) {
            viewMap.clear();
        }
        this._viewRoot = viewRoot;
    }

    public final RenderKit getRenderKit() {
        this.assertNotReleased();
        if (this.getViewRoot() == null) {
            return null;
        }
        String renderKitId = this.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        if (this._cachedRenderKitId == null || !renderKitId.equals(this._cachedRenderKitId)) {
            this._cachedRenderKitId = renderKitId;
            if (this._renderKitFactory == null) {
                this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            }
            this._cachedRenderKit = this._renderKitFactory.getRenderKit(this.getCurrentFacesContext(), renderKitId);
        }
        return this._cachedRenderKit;
    }

    public List<String> getResourceLibraryContracts() {
        this.assertNotReleased();
        if (this._resourceLibraryContracts == null) {
            return Collections.emptyList();
        }
        return this._resourceLibraryContracts;
    }

    public void setResourceLibraryContracts(List<String> contracts) {
        this.assertNotReleased();
        this._resourceLibraryContracts = contracts == null ? null : (contracts.isEmpty() ? null : new ArrayList<String>(contracts));
    }

    public char getNamingContainerSeparatorChar() {
        if (this._separatorChar == null) {
            this._separatorChar = Character.valueOf(UINamingContainer.getSeparatorChar((FacesContext)this));
        }
        return this._separatorChar.charValue();
    }

    protected final void assertNotReleased() {
        if (this._released) {
            throw new IllegalStateException("Error the FacesContext is already released!");
        }
    }

    protected FacesContext getCurrentFacesContext() {
        if (this._currentFacesContext == null) {
            this._currentFacesContext = FacesContext.getCurrentInstance();
        }
        return this._currentFacesContext;
    }
}

