/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.shared.util.ClassUtils;

public class PhaseListenerTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(PhaseListenerTag.class.getName());
    private ValueExpression type = null;
    private ValueExpression binding = null;

    public void setType(ValueExpression type) {
        this.type = type;
    }

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }

    public int doStartTag() throws JspException {
        PhaseListenerTag parent = this;
        UIComponentClassicTagBase parentTag = null;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof UIComponentELTag)) continue;
            parentTag = (UIComponentELTag)((Object)parent);
        }
        if (parentTag == null) {
            throw new JspException("Not nested in a UIViewRoot Error for tag with handler class: " + ((Object)((Object)this)).getClass().getName());
        }
        if (!parentTag.getCreated()) {
            return 0;
        }
        UIViewRoot root = (UIViewRoot)parentTag.getComponentInstance();
        BindingPhaseListener listener = null;
        try {
            listener = new BindingPhaseListener(this.binding, this.type);
        }
        catch (Exception ex) {
            throw new JspException(ex.getMessage(), (Throwable)ex);
        }
        root.addPhaseListener(listener);
        return 0;
    }

    private static class BindingPhaseListener
    implements PhaseListener,
    Serializable {
        private transient PhaseListener phaseListenerCache = null;
        private ValueExpression type;
        private ValueExpression binding;

        BindingPhaseListener(ValueExpression binding, ValueExpression type) {
            this.binding = binding;
            this.type = type;
        }

        @Override
        public void afterPhase(PhaseEvent event) {
            PhaseListener listener = this.getPhaseListener();
            if (listener != null) {
                listener.afterPhase(event);
            }
        }

        @Override
        public void beforePhase(PhaseEvent event) {
            PhaseListener listener = this.getPhaseListener();
            if (listener != null) {
                listener.beforePhase(event);
            }
        }

        @Override
        public PhaseId getPhaseId() {
            PhaseListener listener = this.getPhaseListener();
            if (listener != null) {
                return listener.getPhaseId();
            }
            return null;
        }

        private PhaseListener getPhaseListener() {
            if (this.phaseListenerCache != null) {
                return this.phaseListenerCache;
            }
            this.phaseListenerCache = this.getPhaseListnerInstance(this.binding, this.type);
            if (this.phaseListenerCache == null) {
                log.warning("PhaseListener will not be installed. Both binding and type are null.");
            }
            return this.phaseListenerCache;
        }

        private PhaseListener getPhaseListnerInstance(ValueExpression binding, ValueExpression type) {
            FacesContext currentFacesContext = FacesContext.getCurrentInstance();
            Object phasesInstance = null;
            if (binding != null) {
                phasesInstance = binding.getValue(currentFacesContext.getELContext());
            } else if (type != null) {
                try {
                    phasesInstance = ClassUtils.newInstance((String)type.getValue(currentFacesContext.getELContext()));
                }
                catch (FacesException ex) {
                    throw new AbortProcessingException(ex.getMessage(), ex);
                }
            }
            return (PhaseListener)phasesInstance;
        }
    }
}

