/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.util.Purgeable;

public class ApplicationFactoryImpl
extends ApplicationFactory
implements Purgeable {
    private static final Logger log = Logger.getLogger(ApplicationFactoryImpl.class.getName());
    private Application _application;
    private boolean _myfacesInstanceAddedToApplicationMap = false;

    public ApplicationFactoryImpl() {
        this.createAndLogNewApplication();
    }

    private void createAndLogNewApplication() {
        this._application = new ApplicationImpl();
        this.putApplicationOnMap();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New ApplicationFactory instance created");
        }
    }

    @Override
    public void purge() {
        this.createAndLogNewApplication();
    }

    @Override
    public Application getApplication() {
        if (this._application != null && !this._myfacesInstanceAddedToApplicationMap) {
            this.putApplicationOnMap();
        }
        return this._application;
    }

    @Override
    public void setApplication(Application application) {
        if (application == null) {
            throw new NullPointerException("Cannot set a null application in the ApplicationFactory");
        }
        this._application = application;
        this.putApplicationOnMap();
    }

    private void putApplicationOnMap() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            externalContext.getApplicationMap().put("org.apache.myfaces.application.ApplicationImpl", this._application);
            this._myfacesInstanceAddedToApplicationMap = true;
        }
    }
}

