/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

abstract class AbstractFileCleaner
implements BeforeEachCallback,
AfterEachCallback {
    private static final int MAX_TRIES = Integer.getInteger("log4j2.junit.fileCleanerMaxTries", 10);
    private static final int SLEEP_PERIOD_MILLIS = Integer.getInteger("log4j2.junit.fileCleanerSleepPeriodMillis", 200);

    AbstractFileCleaner() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.clean(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.clean(context);
    }

    private void clean(ExtensionContext context) {
        Collection<Path> paths = this.getPathsForTest(context);
        if (paths.isEmpty()) {
            return;
        }
        ConcurrentHashMap<Path, IOException> failures = new ConcurrentHashMap<Path, IOException>();
        block4: for (Path path : paths) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            for (int i = 0; i < MAX_TRIES; ++i) {
                try {
                    if (this.delete(path)) {
                        failures.remove(path);
                        continue block4;
                    }
                }
                catch (IOException e2) {
                    failures.put(path, e2);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(SLEEP_PERIOD_MILLIS);
                    continue;
                }
                catch (InterruptedException ignored) {
                    failures.put(path, new InterruptedIOException());
                    Thread.currentThread().interrupt();
                    continue block4;
                }
            }
        }
        if (!failures.isEmpty()) {
            String message = failures.entrySet().stream().map(e -> e.getKey() + " failed with " + e.getValue()).collect(Collectors.joining(", "));
            Assertions.fail((String)message);
        }
    }

    abstract Collection<Path> getPathsForTest(ExtensionContext var1);

    abstract boolean delete(Path var1) throws IOException;
}

