/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.monitor.db;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitor;
import org.apache.knox.gateway.topology.monitor.db.LocalDirectory;
import org.apache.knox.gateway.topology.monitor.db.RemoteConfig;
import org.apache.knox.gateway.topology.monitor.db.RemoteConfigDatabase;

public class DbRemoteConfigurationMonitorService
implements RemoteConfigurationMonitor {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    public static final int OFFSET_SECONDS = 5;
    private final RemoteConfigDatabase db;
    private final LocalDirectory providersDir;
    private final LocalDirectory descriptorsDir;
    private final long syncIntervalSeconds;
    private final ScheduledExecutorService executor;
    private final int cleanUpPeriodSeconds;
    private Instant lastSyncTime;

    public DbRemoteConfigurationMonitorService(RemoteConfigDatabase db, LocalDirectory providersDir, LocalDirectory descriptorsDir, long syncIntervalSeconds, int cleanUpPeriodSeconds) {
        this.db = db;
        this.providersDir = providersDir;
        this.descriptorsDir = descriptorsDir;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.syncIntervalSeconds = syncIntervalSeconds;
        this.cleanUpPeriodSeconds = cleanUpPeriodSeconds;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        LOG.initDbRemoteConfigMonitor(this.syncIntervalSeconds, this.cleanUpPeriodSeconds);
    }

    public void start() throws ServiceLifecycleException {
        LOG.startingDbRemoteConfigurationMonitor(this.syncIntervalSeconds);
        this.executor.scheduleWithFixedDelay(this::sync, this.syncIntervalSeconds, this.syncIntervalSeconds, TimeUnit.SECONDS);
        this.executor.scheduleWithFixedDelay(this::cleanUp, this.cleanUpPeriodSeconds, this.cleanUpPeriodSeconds, TimeUnit.SECONDS);
    }

    public void stop() throws ServiceLifecycleException {
        this.executor.shutdown();
    }

    public boolean createProvider(String name, String content) {
        LOG.creatingLocalDescriptorProvider("provider", name);
        return this.db.putProvider(name, content);
    }

    public boolean createDescriptor(String name, String content) {
        LOG.creatingLocalDescriptorProvider("descriptor", name);
        return this.db.putDescriptor(name, content);
    }

    public boolean deleteProvider(String name) {
        LOG.deletingLocalDescriptorProvider("provider", name);
        return this.db.deleteProvider(name);
    }

    public boolean deleteDescriptor(String name) {
        LOG.deletingLocalDescriptorProvider("descriptor", name);
        return this.db.deleteDescriptor(name);
    }

    public void sync() {
        try {
            this.syncLocalWithRemote(this.db.selectProviders(), this.providersDir);
            this.syncLocalWithRemote(this.db.selectDescriptors(), this.descriptorsDir);
            this.lastSyncTime = Instant.now();
            LOG.remoteConfigurationSyncCompleted(this.lastSyncTime);
        }
        catch (Exception e) {
            LOG.errorWhileSyncingLocalFileSystem(e);
        }
    }

    private void syncLocalWithRemote(List<RemoteConfig> remoteConfigs, LocalDirectory localDir) {
        List<RemoteConfig> existingConfigs = remoteConfigs.stream().filter(each -> !each.isDeleted()).collect(Collectors.toList());
        this.createOrUpdateLocalFiles(existingConfigs, localDir);
        Set<String> deletedConfigs = remoteConfigs.stream().filter(RemoteConfig::isDeleted).map(RemoteConfig::getName).collect(Collectors.toSet());
        this.deleteLocalFiles(deletedConfigs, localDir);
    }

    private void createOrUpdateLocalFiles(List<RemoteConfig> remoteConfigs, LocalDirectory localDir) {
        Set<String> localFiles = localDir.list();
        for (RemoteConfig remoteConfig : remoteConfigs) {
            try {
                String remoteContent = remoteConfig.getContent();
                if (!localFiles.contains(remoteConfig.getName())) {
                    LOG.downloadingProviderDescriptor(remoteConfig.getName(), localDir);
                    localDir.writeFile(remoteConfig.getName(), remoteContent);
                    continue;
                }
                if (!this.shouldUpdateContent(remoteConfig, localDir)) continue;
                LOG.downloadingProviderDescriptor(remoteConfig.getName(), localDir);
                localDir.writeFile(remoteConfig.getName(), remoteContent);
            }
            catch (IOException e) {
                LOG.errorSynchronizingLocalProviderDescriptor(localDir, e);
            }
        }
    }

    private boolean shouldUpdateContent(RemoteConfig remoteConfig, LocalDirectory localDir) throws IOException {
        if (this.lastSyncTime == null || remoteConfig.getLastModified().isAfter(this.lastSyncTime.minusSeconds(5L))) {
            return !remoteConfig.getContent().equals(localDir.fileContent(remoteConfig.getName()));
        }
        return false;
    }

    private void deleteLocalFiles(Set<String> deletedRemoteConfigNames, LocalDirectory localDir) {
        for (String localFileName : localDir.list()) {
            if (!deletedRemoteConfigNames.contains(localFileName) || !localDir.deleteFile(localFileName)) continue;
            LOG.deletingProviderDescriptor(localFileName, localDir);
        }
    }

    private void cleanUp() {
        LOG.cleaningRemoteConfigTables(this.cleanUpPeriodSeconds);
        this.db.cleanTables(this.cleanUpPeriodSeconds);
    }
}

