/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.http.adapter;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;

public class JEEHttpActionAdapter
implements HttpActionAdapter<Object, JEEContext> {
    public static final JEEHttpActionAdapter INSTANCE = new JEEHttpActionAdapter();

    @Override
    public Object adapt(HttpAction action, JEEContext context) {
        if (action != null) {
            WithContentAction withContentAction;
            String content;
            int code = action.getCode();
            HttpServletResponse response = context.getNativeResponse();
            if (code < 400) {
                response.setStatus(code);
            } else {
                try {
                    response.sendError(code);
                }
                catch (IOException e) {
                    throw new TechnicalException(e);
                }
            }
            if (action instanceof WithLocationAction) {
                WithLocationAction withLocationAction = (WithLocationAction)((Object)action);
                context.setResponseHeader("Location", withLocationAction.getLocation());
            } else if (action instanceof WithContentAction && (content = (withContentAction = (WithContentAction)((Object)action)).getContent()) != null) {
                try {
                    response.getWriter().write(content);
                }
                catch (IOException e) {
                    throw new TechnicalException(e);
                }
            }
            return null;
        }
        throw new TechnicalException("No action provided");
    }
}

