/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.plugin.Codec;

public class TimestampCodec
implements Codec<Timestamp> {
    public static final TimestampCodec INSTANCE = new TimestampCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATE, new DataType[]{DataType.NEWDATE, DataType.DATETIME, DataType.TIMESTAMP, DataType.YEAR, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.TIME, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Timestamp.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Timestamp.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Timestamp;
    }

    @Override
    public Timestamp decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeTimestampText(buf, length, cal);
    }

    @Override
    public Timestamp decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeTimestampBinary(buf, length, cal);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Timestamp ts = (Timestamp)val;
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(ts);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        int microseconds = ts.getNanos() / 1000;
        if (microseconds > 0) {
            if (microseconds % 1000 == 0) {
                encoder.writeAscii("." + Integer.toString(microseconds / 1000 + 1000).substring(1));
            } else {
                encoder.writeAscii("." + Integer.toString(microseconds + 1000000).substring(1));
            }
        }
        encoder.writeByte(39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar providedCal, Long maxLength) throws IOException {
        Timestamp ts = (Timestamp)value;
        if (providedCal == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTimeInMillis(ts.getTime());
            if (ts.getNanos() == 0) {
                encoder.writeByte(7);
                encoder.writeShort((short)cal.get(1));
                encoder.writeByte(cal.get(2) + 1);
                encoder.writeByte(cal.get(5));
                encoder.writeByte(cal.get(11));
                encoder.writeByte(cal.get(12));
                encoder.writeByte(cal.get(13));
            } else {
                encoder.writeByte(11);
                encoder.writeShort((short)cal.get(1));
                encoder.writeByte(cal.get(2) + 1);
                encoder.writeByte(cal.get(5));
                encoder.writeByte(cal.get(11));
                encoder.writeByte(cal.get(12));
                encoder.writeByte(cal.get(13));
                encoder.writeInt(ts.getNanos() / 1000);
            }
        } else {
            Calendar calendar = providedCal;
            synchronized (calendar) {
                providedCal.clear();
                providedCal.setTimeInMillis(ts.getTime());
                if (ts.getNanos() == 0) {
                    encoder.writeByte(7);
                    encoder.writeShort((short)providedCal.get(1));
                    encoder.writeByte(providedCal.get(2) + 1);
                    encoder.writeByte(providedCal.get(5));
                    encoder.writeByte(providedCal.get(11));
                    encoder.writeByte(providedCal.get(12));
                    encoder.writeByte(providedCal.get(13));
                } else {
                    encoder.writeByte(11);
                    encoder.writeShort((short)providedCal.get(1));
                    encoder.writeByte(providedCal.get(2) + 1);
                    encoder.writeByte(providedCal.get(5));
                    encoder.writeByte(providedCal.get(11));
                    encoder.writeByte(providedCal.get(12));
                    encoder.writeByte(providedCal.get(13));
                    encoder.writeInt(ts.getNanos() / 1000);
                }
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }
}

