/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import java.util.HashMap;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.service.knoxtoken.PasscodeTokenResourceBase;
import org.apache.knox.gateway.service.knoxtoken.TokenResource;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenMetadataType;
import org.apache.knox.gateway.util.JsonUtils;

@Path(value="clientid/api/v1/oauth/credentials")
@Singleton
public class ClientCredentialsResource
extends PasscodeTokenResourceBase {
    private static final String TYPE = "type";
    public static final String RESOURCE_PATH = "clientid/api/v1/oauth/credentials";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    private static final String PREFIX = "clientid.";

    @Override
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return super.doGet();
    }

    @Override
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return super.doPost();
    }

    @Override
    protected void addArbitraryTokenMetadata(TokenMetadata tokenMetadata) {
        tokenMetadata.add(TYPE, TokenMetadataType.CLIENT_ID.name());
        super.addArbitraryTokenMetadata(tokenMetadata);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Response getAuthenticationToken() {
        TokenResource.UserContext context = this.buildUserContext(this.request);
        Response response = this.checkForInvalidRequestResponse(context);
        if (response != null) {
            return response;
        }
        TokenResource.TokenResponseContext resp = this.getTokenResponse(context);
        if (resp.responseMap != null) {
            String passcode = (String)resp.responseMap.map.get("passcode");
            String tokenId = resp.responseMap.tokenId;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CLIENT_ID, tokenId);
            map.put(CLIENT_SECRET, passcode);
            this.addExpiryIfNotNever(map);
            String jsonResponse = JsonUtils.renderAsJsonString(map);
            return resp.responseBuilder.entity((Object)jsonResponse).build();
        }
        if (resp.responseStr != null) {
            return resp.responseBuilder.entity((Object)resp.responseStr).build();
        }
        return resp.responseBuilder.build();
    }
}

