/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;

public final class InitializationSupport {
    private static boolean initialized;

    private InitializationSupport() {
    }

    private static boolean haveECCProvider() {
        try {
            Signature.getInstance("SHA256withECDSA");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    private static void addBouncyCastleProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static void initialize() throws InitializationException {
        if (initialized) {
            return;
        }
        if (!InitializationSupport.haveECCProvider()) {
            InitializationSupport.addBouncyCastleProvider();
        }
        InitializationService.initialize();
        initialized = true;
    }
}

