/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.Channel;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientHolder;

public class SftpDirEntryIterator
extends AbstractLoggingBean
implements SftpClientHolder,
Iterator<SftpClient.DirEntry>,
Channel {
    private final AtomicReference<Boolean> eolIndicator = new AtomicReference();
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final SftpClient client;
    private final String dirPath;
    private final boolean closeOnFinished;
    private SftpClient.Handle dirHandle;
    private List<SftpClient.DirEntry> dirEntries;
    private int index;

    public SftpDirEntryIterator(SftpClient client, String path) throws IOException {
        this(client, path, client.openDir(path), true);
    }

    public SftpDirEntryIterator(SftpClient client, SftpClient.Handle dirHandle) {
        this(client, Objects.toString(dirHandle, null), dirHandle, false);
    }

    public SftpDirEntryIterator(SftpClient client, String path, SftpClient.Handle dirHandle, boolean closeOnFinished) {
        this.client = Objects.requireNonNull(client, "No SFTP client instance");
        this.dirPath = ValidateUtils.hasContent((String)path, (String)"No path");
        this.dirHandle = Objects.requireNonNull(dirHandle, "No directory handle");
        this.closeOnFinished = closeOnFinished;
        this.dirEntries = this.load(dirHandle);
    }

    @Override
    public final SftpClient getClient() {
        return this.client;
    }

    public final String getPath() {
        return this.dirPath;
    }

    public final SftpClient.Handle getHandle() {
        return this.dirHandle;
    }

    @Override
    public boolean hasNext() {
        return this.dirEntries != null && this.index < this.dirEntries.size();
    }

    @Override
    public SftpClient.DirEntry next() {
        SftpClient.DirEntry entry = this.dirEntries.get(this.index++);
        if (this.index >= this.dirEntries.size()) {
            this.index = 0;
            try {
                this.dirEntries = this.load(this.getHandle());
            }
            catch (RuntimeException e) {
                this.dirEntries = null;
                throw e;
            }
        }
        return entry;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    public boolean isCloseOnFinished() {
        return this.closeOnFinished;
    }

    @Override
    public void close() throws IOException {
        SftpClient.Handle handle;
        if (this.open.getAndSet(false) && (handle = this.getHandle()) instanceof Closeable && this.isCloseOnFinished()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("close({}) handle={}", (Object)this.getPath(), (Object)handle);
            }
            ((Closeable)((Object)handle)).close();
        }
    }

    protected List<SftpClient.DirEntry> load(SftpClient.Handle handle) {
        try {
            Boolean eolReached = this.eolIndicator.getAndSet(null);
            if (eolReached != null && eolReached.booleanValue()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("load({})[{}] exhausted all entries on previous call", (Object)this.getPath(), (Object)handle);
                }
                return null;
            }
            List<SftpClient.DirEntry> entries = this.client.readDir(handle, this.eolIndicator);
            eolReached = this.eolIndicator.get();
            if (entries == null || eolReached != null && eolReached.booleanValue()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("load({})[{}] exhausted all entries - EOL={}", new Object[]{this.getPath(), handle, eolReached});
                }
                this.close();
            }
            return entries;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException t) {
                e.addSuppressed(t);
                this.debug("{} while close handle={} due to {} [{}]: {}", t.getClass().getSimpleName(), handle, e.getClass().getSimpleName(), e.getMessage(), t);
            }
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("readDir(" + this.getPath() + ")[" + this.getHandle() + "] Iterator#remove() N/A");
    }
}

