/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.Language;

public class SimpleExpressionReifier
extends ExpressionReifier<SimpleExpression> {
    public SimpleExpressionReifier(CamelContext camelContext, ExpressionDefinition definition) {
        super(camelContext, (SimpleExpression)definition);
    }

    @Override
    public Expression createExpression() {
        final Expression expr = this.createBuilder().createExpression(this.camelContext);
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                return (T)expr.evaluate(exchange, type);
            }

            public String toString() {
                return ((SimpleExpression)SimpleExpressionReifier.this.definition).getExpression();
            }
        };
    }

    @Override
    public Predicate createPredicate() {
        final Predicate pred = this.createBuilder().createPredicate(this.camelContext);
        return new Predicate(){

            public boolean matches(Exchange exchange) {
                return pred.matches(exchange);
            }

            public String toString() {
                return ((SimpleExpression)SimpleExpressionReifier.this.definition).getExpression();
            }
        };
    }

    protected SimpleBuilder createBuilder() {
        String exp = this.parseString(((SimpleExpression)this.definition).getExpression());
        boolean isTrim = this.parseBoolean(((SimpleExpression)this.definition).getTrim(), true);
        if (exp != null && isTrim) {
            exp = exp.trim();
        }
        SimpleBuilder answer = new SimpleBuilder(exp);
        this.configureLanguage(null);
        answer.setResultType(((SimpleExpression)this.definition).getResultType());
        return answer;
    }

    @Override
    protected Expression createExpression(Language language, String exp) {
        ((SimpleExpression)this.definition).setExpression(exp);
        return this.createBuilder();
    }

    @Override
    protected Predicate createPredicate(Language language, String exp) {
        ((SimpleExpression)this.definition).setExpression(exp);
        return this.createBuilder();
    }

    @Override
    protected void configureLanguage(Language language) {
        if (((SimpleExpression)this.definition).getResultType() == null && ((SimpleExpression)this.definition).getResultTypeName() != null) {
            Class clazz;
            try {
                clazz = this.camelContext.getClassResolver().resolveMandatoryClass(((SimpleExpression)this.definition).getResultTypeName());
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
            ((SimpleExpression)this.definition).setResultType(clazz);
        }
    }
}

