/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import aQute.lib.collections.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiMap<K, V>
implements Map<K, List<V>> {
    private final boolean noduplicates;
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final Map<K, List<V>> map;

    public MultiMap() {
        this(false);
    }

    public MultiMap(boolean noduplicates) {
        this(Object.class, Object.class, noduplicates);
    }

    public MultiMap(Class<? extends K> keyClass, Class<? extends V> valueClass, boolean noduplicates) {
        this.noduplicates = noduplicates;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.map = new LinkedHashMap<K, List<V>>();
    }

    public MultiMap(Map<? extends K, ? extends Collection<? extends V>> other) {
        this();
        this.addAll(other);
    }

    public <S extends K, T extends V> MultiMap(MultiMap<S, T> other) {
        this(other.keyClass, other.valueClass, other.noduplicates);
        this.addAll(other);
    }

    private List<V> newValue(K key) {
        if (this.valueClass != Object.class) {
            return Collections.checkedList(new ArrayList(), this.valueClass);
        }
        return new ArrayList();
    }

    public boolean add(K key, V value) {
        assert (this.keyClass.isInstance(key));
        assert (this.valueClass.isInstance(value));
        Object values = this.computeIfAbsent((Object)key, this::newValue);
        if (this.noduplicates && values.contains(value)) {
            return false;
        }
        return values.add(value);
    }

    public boolean addAll(K key, Collection<? extends V> value) {
        assert (this.keyClass.isInstance(key));
        if (value == null || value.isEmpty()) {
            return false;
        }
        Object values = this.computeIfAbsent((Object)key, this::newValue);
        if (this.noduplicates) {
            boolean added = false;
            for (V v : value) {
                assert (this.valueClass.isInstance(v));
                if (values.contains(v)) continue;
                values.add(v);
                added = true;
            }
            return added;
        }
        return values.addAll(value);
    }

    public boolean addAll(Map<? extends K, ? extends Collection<? extends V>> other) {
        boolean added = false;
        for (Map.Entry<K, Collection<V>> entry : other.entrySet()) {
            if (!this.addAll(entry.getKey(), entry.getValue())) continue;
            added = true;
        }
        return added;
    }

    public boolean removeValue(K key, V value) {
        assert (this.keyClass.isInstance(key));
        assert (this.valueClass.isInstance(value));
        Object values = this.get(key);
        if (values == null) {
            return false;
        }
        boolean result = values.remove(value);
        if (values.isEmpty()) {
            this.remove(key);
        }
        return result;
    }

    public boolean removeAll(K key, Collection<? extends V> value) {
        assert (this.keyClass.isInstance(key));
        Object values = this.get(key);
        if (values == null) {
            return false;
        }
        boolean result = values.removeAll(value);
        if (values.isEmpty()) {
            this.remove(key);
        }
        return result;
    }

    public Iterator<V> iterate(K key) {
        assert (this.keyClass.isInstance(key));
        Object values = this.get(key);
        if (values == null) {
            return Collections.emptyIterator();
        }
        return values.iterator();
    }

    private Stream<V> valuesStream() {
        return this.values().stream().filter(Objects::nonNull).flatMap(Collection::stream);
    }

    public Iterator<V> all() {
        return this.valuesStream().iterator();
    }

    public Map<K, V> flatten() {
        LinkedHashMap<K, V> flattened = new LinkedHashMap<K, V>();
        for (Map.Entry<K, List<V>> entry : this.entrySet()) {
            List<V> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            flattened.put(entry.getKey(), values.get(0));
        }
        return flattened;
    }

    public MultiMap<V, K> transpose() {
        return this.transpose(false);
    }

    public MultiMap<V, K> transpose(boolean noduplicates) {
        MultiMap<K, V> transposed = new MultiMap<K, V>(this.valueClass, this.keyClass, noduplicates);
        for (Map.Entry<K, List<V>> entry : this.entrySet()) {
            List<V> keys = entry.getValue();
            if (keys == null) continue;
            K value = entry.getKey();
            for (V key : keys) {
                if (key == null) continue;
                transposed.add(key, value);
            }
        }
        return transposed;
    }

    public List<V> allValues() {
        return this.valuesStream().collect(Collectors.toList());
    }

    public static <T extends Comparable<? super T>> String format(Map<T, ? extends Collection<?>> map) {
        try (Formatter f = new Formatter();){
            SortedList keys = new SortedList(map.keySet());
            for (Object key : keys) {
                String name = key.toString();
                SortedList values = new SortedList(map.get(key), null);
                String list = MultiMap.vertical(40, values);
                f.format("%-39s %s", name, list);
            }
            String string = f.toString();
            return string;
        }
    }

    static String vertical(int padding, Collection<?> used) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object s : used) {
            String name = s.toString();
            sb.append(del);
            sb.append(name);
            sb.append("\r\n");
            del = MultiMap.pad(padding);
        }
        if (sb.length() == 0) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    static String pad(int i) {
        StringBuilder sb = new StringBuilder();
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public List<V> getOrDefault(Object key, List<V> defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super List<V>> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super List<V>, ? extends List<V>> function) {
        this.map.replaceAll(function);
    }

    @Override
    public List<V> putIfAbsent(K key, List<V> value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(K key, List<V> oldValue, List<V> newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public List<V> replace(K key, List<V> value) {
        return this.map.replace(key, value);
    }

    @Override
    public List<V> computeIfAbsent(K key, Function<? super K, ? extends List<V>> mappingFunction) {
        return this.map.computeIfAbsent((K)key, (Function<? super K, List<? extends List<V>>>)mappingFunction);
    }

    @Override
    public List<V> computeIfPresent(K key, BiFunction<? super K, ? super List<V>, ? extends List<V>> remappingFunction) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, List<? extends List<V>>, List<? extends List<V>>>)remappingFunction);
    }

    @Override
    public List<V> compute(K key, BiFunction<? super K, ? super List<V>, ? extends List<V>> remappingFunction) {
        return this.map.compute((K)key, (BiFunction<? super K, List<? extends List<V>>, List<? extends List<V>>>)remappingFunction);
    }

    @Override
    public List<V> merge(K key, List<V> value, BiFunction<? super List<V>, ? super List<V>, ? extends List<V>> remappingFunction) {
        return this.map.merge(key, value, remappingFunction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.map, this.keyClass, this.valueClass, this.noduplicates);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiMap)) {
            return false;
        }
        MultiMap other = (MultiMap)obj;
        return Objects.equals(this.map, other.map) && Objects.equals(this.keyClass, other.keyClass) && Objects.equals(this.valueClass, other.valueClass) && this.noduplicates == other.noduplicates;
    }

    public String toString() {
        return this.map.toString();
    }

    public MultiMap<K, V> groupBy(Collection<? extends V> collection, Function<? super V, ? extends K> classifier) {
        assert (collection != null);
        assert (classifier != null);
        collection.forEach((? super T v) -> this.add(classifier.apply((V)v), v));
        return this;
    }
}

