/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotCompatibleTsFileException;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.Schema;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestorableTsFileIOWriter
extends TsFileIOWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"FileMonitor");
    private long truncatedSize;
    private int lastFlushedChunkGroupIndex;
    private boolean crashed;
    private long minPlanIndex;
    private long maxPlanIndex;
    private final Map<IDeviceID, Map<String, List<ChunkMetadata>>> metadatasForQuery;

    public RestorableTsFileIOWriter(File file) throws IOException {
        this(file, true);
    }

    public RestorableTsFileIOWriter(File file, long maxMetadataSize) throws IOException {
        this(file, true);
        this.maxMetadataSize = maxMetadataSize;
        this.chunkMetadataTempFile = new File(file.getAbsolutePath() + ".meta");
        this.checkMetadataSizeAndMayFlush();
    }

    public RestorableTsFileIOWriter(File file, boolean truncate) throws IOException {
        block13: {
            this.truncatedSize = -1L;
            this.lastFlushedChunkGroupIndex = 0;
            this.minPlanIndex = Long.MAX_VALUE;
            this.maxPlanIndex = Long.MIN_VALUE;
            this.metadatasForQuery = new HashMap<IDeviceID, Map<String, List<ChunkMetadata>>>();
            if (logger.isDebugEnabled()) {
                logger.debug("{} is opened.", (Object)file.getName());
            }
            this.file = file;
            this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(file.getPath(), true);
            if (file.length() == 0L) {
                this.startFile();
                this.crashed = true;
                this.canWrite = true;
                return;
            }
            try {
                if (!file.exists()) break block13;
                try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
                    this.schema.setEnabledUpdateSchema(false);
                    this.truncatedSize = reader.selfCheck(this.schema, this.chunkGroupMetadataList, true);
                    this.minPlanIndex = reader.getMinPlanIndex();
                    this.maxPlanIndex = reader.getMaxPlanIndex();
                    if (this.truncatedSize == 0L) {
                        this.crashed = false;
                        this.canWrite = false;
                        this.out.close();
                    } else {
                        if (this.truncatedSize == -2L) {
                            this.out.close();
                            throw new NotCompatibleTsFileException(String.format("%s is not in TsFile format.", file.getAbsolutePath()));
                        }
                        this.crashed = true;
                        this.canWrite = true;
                        if (truncate) {
                            this.out.truncate(this.truncatedSize);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.out.close();
                throw e;
            }
        }
    }

    public static RestorableTsFileIOWriter getWriterForAppendingDataOnCompletedTsFile(File file) throws IOException {
        long position = file.length();
        try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
            if (reader.isComplete()) {
                reader.loadMetadataSize();
                position = reader.getFileMetadataPos();
            }
        }
        if (position != file.length()) {
            try (FileChannel channel = FileChannel.open(Paths.get(file.getAbsolutePath(), new String[0]), StandardOpenOption.WRITE);){
                channel.truncate(position - 1L);
            }
        }
        return new RestorableTsFileIOWriter(file);
    }

    long getTruncatedSize() {
        return this.truncatedSize;
    }

    public Schema getKnownSchema() {
        return this.schema;
    }

    public List<ChunkMetadata> getVisibleMetadataList(IDeviceID deviceId, String measurementId, TSDataType dataType) {
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        if (this.metadatasForQuery.containsKey(deviceId) && this.metadatasForQuery.get(deviceId).containsKey(measurementId)) {
            for (ChunkMetadata chunkMetaData : this.metadatasForQuery.get(deviceId).get(measurementId)) {
                if (dataType != null && !dataType.isCompatible(chunkMetaData.getDataType())) continue;
                chunkMetadataList.add(chunkMetaData);
            }
        }
        return chunkMetadataList;
    }

    public List<List<ChunkMetadata>> getVisibleMetadataList(IDeviceID deviceId, TSDataType dataType) {
        ArrayList<List<ChunkMetadata>> chunkMetadataForEachMeasurement = new ArrayList<List<ChunkMetadata>>();
        if (this.metadatasForQuery.containsKey(deviceId)) {
            for (List<ChunkMetadata> deviceChunkMetadataList : this.metadatasForQuery.get(deviceId).values()) {
                List curChunkMetadataList = deviceChunkMetadataList.stream().filter(chunkMetaData -> dataType == null || dataType.equals((Object)chunkMetaData.getDataType())).collect(Collectors.toList());
                chunkMetadataForEachMeasurement.add(curChunkMetadataList);
            }
        }
        return chunkMetadataForEachMeasurement;
    }

    public Map<IDeviceID, Map<String, List<ChunkMetadata>>> getMetadatasForQuery() {
        return this.metadatasForQuery;
    }

    public void makeMetadataVisible() {
        List<ChunkGroupMetadata> newlyFlushedMetadataList = this.getAppendedRowMetadata();
        if (!newlyFlushedMetadataList.isEmpty()) {
            for (ChunkGroupMetadata chunkGroupMetadata : newlyFlushedMetadataList) {
                List<ChunkMetadata> rowMetaDataList = chunkGroupMetadata.getChunkMetadataList();
                IDeviceID device = chunkGroupMetadata.getDevice();
                for (ChunkMetadata chunkMetaData : rowMetaDataList) {
                    String measurementId = chunkMetaData.getMeasurementUid();
                    if (!this.metadatasForQuery.containsKey(device)) {
                        this.metadatasForQuery.put(device, new HashMap());
                    }
                    if (!this.metadatasForQuery.get(device).containsKey(measurementId)) {
                        this.metadatasForQuery.get(device).put(measurementId, new ArrayList());
                    }
                    this.metadatasForQuery.get(device).get(measurementId).add(chunkMetaData);
                }
            }
        }
    }

    public boolean hasCrashed() {
        return this.crashed;
    }

    private List<ChunkGroupMetadata> getAppendedRowMetadata() {
        ArrayList<ChunkGroupMetadata> append = new ArrayList<ChunkGroupMetadata>();
        if (this.lastFlushedChunkGroupIndex < this.chunkGroupMetadataList.size()) {
            append.addAll(this.chunkGroupMetadataList.subList(this.lastFlushedChunkGroupIndex, this.chunkGroupMetadataList.size()));
            this.lastFlushedChunkGroupIndex = this.chunkGroupMetadataList.size();
        }
        return append;
    }

    public void addSchema(Path path, IMeasurementSchema schema) {
        this.schema.registerTimeseries(path.getIDeviceID(), schema);
    }

    @Override
    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    @Override
    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }
}

