/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.sink;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.agent.task.connection.BlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.agent.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeCompactedTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimePriorityBlockingQueue
extends UnboundedBlockingPendingQueue<Event> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimePriorityBlockingQueue.class);
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();
    private final BlockingDeque<TsFileInsertionEvent> tsfileInsertEventDeque = new LinkedBlockingDeque<TsFileInsertionEvent>();
    private final AtomicInteger pollTsFileCounter = new AtomicInteger(0);
    private final AtomicLong pollHistoricalTsFileCounter = new AtomicLong(0L);
    private AtomicInteger offerTsFileCounter = new AtomicInteger(0);

    public PipeRealtimePriorityBlockingQueue() {
        super((PipeEventCounter)new PipeDataRegionEventCounter());
    }

    public boolean directOffer(Event event) {
        this.checkBeforeOffer(event);
        if (event instanceof TsFileInsertionEvent) {
            this.tsfileInsertEventDeque.add((TsFileInsertionEvent)event);
            return true;
        }
        if (event instanceof PipeHeartbeatEvent && super.peekLast() instanceof PipeHeartbeatEvent) {
            ((EnrichedEvent)event).decreaseReferenceCount(PipeEventCollector.class.getName(), false);
            return false;
        }
        return super.directOffer(event);
    }

    public boolean waitedOffer(Event event) {
        return this.directOffer(event);
    }

    public boolean put(Event event) {
        this.directOffer(event);
        return true;
    }

    public Event directPoll() {
        Event event = null;
        int pollHistoricalTsFileThreshold = PIPE_CONFIG.getPipeRealTimeQueuePollHistoricalTsFileThreshold();
        int realTimeQueueMaxWaitingTsFileSize = PIPE_CONFIG.getPipeRealTimeQueueMaxWaitingTsFileSize();
        if (this.pollTsFileCounter.get() >= PIPE_CONFIG.getPipeRealTimeQueuePollTsFileThreshold() && this.offerTsFileCounter.get() < realTimeQueueMaxWaitingTsFileSize) {
            event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)pollHistoricalTsFileThreshold == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            this.pollTsFileCounter.set(0);
        }
        if (Objects.isNull(event)) {
            event = super.directPoll();
            if (Objects.isNull(event) && this.offerTsFileCounter.get() < realTimeQueueMaxWaitingTsFileSize) {
                Event event2 = event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)pollHistoricalTsFileThreshold == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            }
            if (event != null) {
                this.pollTsFileCounter.incrementAndGet();
            }
        }
        return event;
    }

    public Event waitedPoll() {
        Event event = null;
        int pollHistoricalTsFileThreshold = PIPE_CONFIG.getPipeRealTimeQueuePollHistoricalTsFileThreshold();
        int realTimeQueueMaxWaitingTsFileSize = PIPE_CONFIG.getPipeRealTimeQueueMaxWaitingTsFileSize();
        if (this.pollTsFileCounter.get() >= PIPE_CONFIG.getPipeRealTimeQueuePollTsFileThreshold() && this.offerTsFileCounter.get() < realTimeQueueMaxWaitingTsFileSize) {
            event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)pollHistoricalTsFileThreshold == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            this.pollTsFileCounter.set(0);
        }
        if (event == null) {
            event = super.directPoll();
            if (event == null && !this.tsfileInsertEventDeque.isEmpty()) {
                Event event2 = event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)pollHistoricalTsFileThreshold == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            }
            if (event != null) {
                this.pollTsFileCounter.incrementAndGet();
            }
        }
        if (Objects.isNull(event) && this.offerTsFileCounter.get() < realTimeQueueMaxWaitingTsFileSize) {
            event = super.waitedPoll();
            if (Objects.isNull(event)) {
                Event event3 = event = this.pollHistoricalTsFileCounter.incrementAndGet() % (long)pollHistoricalTsFileThreshold == 0L ? (Event)this.tsfileInsertEventDeque.pollFirst() : (Event)this.tsfileInsertEventDeque.pollLast();
            }
            if (event != null) {
                this.pollTsFileCounter.incrementAndGet();
            }
        }
        return event;
    }

    public Event peek() {
        Event event = (Event)this.pendingQueue.peek();
        if (Objects.nonNull(event)) {
            return event;
        }
        return (Event)this.tsfileInsertEventDeque.peek();
    }

    public synchronized void replace(String dataRegionId, Set<TsFileResource> sourceFiles, List<TsFileResource> targetFiles) {
        int regionId = Integer.parseInt(dataRegionId);
        Map<CommitterKey, Set> eventsToBeRemovedGroupByCommitterKey = this.tsfileInsertEventDeque.stream().filter(event -> event instanceof PipeTsFileInsertionEvent && ((PipeTsFileInsertionEvent)event).getRegionId() == regionId).map(event -> (PipeTsFileInsertionEvent)event).collect(Collectors.groupingBy(EnrichedEvent::getCommitterKey, Collectors.toSet())).entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() == sourceFiles.size()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (eventsToBeRemovedGroupByCommitterKey.isEmpty()) {
            LOGGER.info("Region {}: No TsFileInsertionEvents to replace for source files {}", (Object)regionId, (Object)sourceFiles.stream().map(TsFileResource::getTsFilePath).collect(Collectors.joining(", ")));
            return;
        }
        HashMap<Object, Object> eventsToBeAddedGroupByCommitterKey = new HashMap<Object, Object>();
        for (Map.Entry<CommitterKey, Set> entry2 : eventsToBeRemovedGroupByCommitterKey.entrySet()) {
            CommitterKey committerKey = entry2.getKey();
            PipeTsFileInsertionEvent pipeTsFileInsertionEvent = entry2.getValue().stream().findFirst().orElse(null);
            HashSet newEvents = new HashSet();
            for (int i = 0; i < targetFiles.size(); ++i) {
                newEvents.add(new PipeCompactedTsFileInsertionEvent(committerKey, entry2.getValue(), pipeTsFileInsertionEvent, targetFiles.get(i), i == targetFiles.size() - 1));
            }
            eventsToBeAddedGroupByCommitterKey.put(committerKey, newEvents);
        }
        HashSet<PipeTsFileInsertionEvent> successfullyReferenceIncreasedEvents = new HashSet<PipeTsFileInsertionEvent>();
        AtomicBoolean allSuccess = new AtomicBoolean(true);
        block8: for (Map.Entry entry2 : eventsToBeAddedGroupByCommitterKey.entrySet()) {
            for (PipeTsFileInsertionEvent event2 : (Set)entry2.getValue()) {
                if (event2 == null) continue;
                try {
                    if (!event2.increaseReferenceCount(PipeRealtimePriorityBlockingQueue.class.getName())) {
                        allSuccess.set(false);
                        break block8;
                    }
                    successfullyReferenceIncreasedEvents.add(event2);
                }
                catch (Exception e) {
                    allSuccess.set(false);
                    break block8;
                }
            }
        }
        if (!allSuccess.get()) {
            for (PipeTsFileInsertionEvent pipeTsFileInsertionEvent : successfullyReferenceIncreasedEvents) {
                try {
                    pipeTsFileInsertionEvent.decreaseReferenceCount(PipeRealtimePriorityBlockingQueue.class.getName(), false);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to decrease reference count for event {} in PipeRealtimePriorityBlockingQueue", (Object)pipeTsFileInsertionEvent, (Object)e);
                }
            }
            return;
        }
        for (PipeTsFileInsertionEvent pipeTsFileInsertionEvent : successfullyReferenceIncreasedEvents) {
            this.tsfileInsertEventDeque.add(pipeTsFileInsertionEvent);
            this.eventCounter.increaseEventCount((Event)pipeTsFileInsertionEvent);
        }
        for (Map.Entry entry3 : eventsToBeRemovedGroupByCommitterKey.entrySet()) {
            for (PipeTsFileInsertionEvent event4 : (Set)entry3.getValue()) {
                if (event4 == null) continue;
                try {
                    event4.decreaseReferenceCount(PipeRealtimePriorityBlockingQueue.class.getName(), false);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to decrease reference count for event {} in PipeRealtimePriorityBlockingQueue", (Object)event4, (Object)e);
                }
                this.eventCounter.decreaseEventCount((Event)event4);
            }
        }
        HashSet eventsToRemove = new HashSet();
        for (Set pipeTsFileInsertionEvents : eventsToBeRemovedGroupByCommitterKey.values()) {
            eventsToRemove.addAll(pipeTsFileInsertionEvents);
        }
        this.tsfileInsertEventDeque.removeIf(eventsToRemove::contains);
        LOGGER.info("Region {}: Replaced TsFileInsertionEvents {} with {}", new Object[]{regionId, eventsToBeRemovedGroupByCommitterKey.values().stream().flatMap(Collection::stream).map(PipeTsFileInsertionEvent::coreReportMessage).collect(Collectors.joining(", ")), eventsToBeAddedGroupByCommitterKey.values().stream().flatMap(Collection::stream).map(PipeTsFileInsertionEvent::coreReportMessage).collect(Collectors.joining(", "))});
    }

    public void clear() {
        super.clear();
        this.tsfileInsertEventDeque.clear();
    }

    public void forEach(Consumer<? super Event> action) {
        super.forEach(action);
        this.tsfileInsertEventDeque.forEach(action);
    }

    public void discardAllEvents() {
        super.discardAllEvents();
        this.tsfileInsertEventDeque.removeIf(event -> {
            if (event instanceof EnrichedEvent && ((EnrichedEvent)event).clearReferenceCount(BlockingPendingQueue.class.getName())) {
                this.eventCounter.decreaseEventCount((Event)event);
            }
            return true;
        });
        this.eventCounter.reset();
    }

    public void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        super.discardEventsOfPipe(pipeNameToDrop, regionId);
        this.tsfileInsertEventDeque.removeIf(event -> {
            if (event instanceof EnrichedEvent && pipeNameToDrop.equals(((EnrichedEvent)event).getPipeName()) && regionId == ((EnrichedEvent)event).getRegionId()) {
                if (((EnrichedEvent)event).clearReferenceCount(PipeRealtimePriorityBlockingQueue.class.getName())) {
                    this.eventCounter.decreaseEventCount((Event)event);
                }
                return true;
            }
            return false;
        });
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.tsfileInsertEventDeque.isEmpty();
    }

    public int size() {
        return super.size() + this.tsfileInsertEventDeque.size();
    }

    public int getTsFileInsertionEventCount() {
        return this.tsfileInsertEventDeque.size();
    }

    public synchronized void setOfferTsFileCounter(AtomicInteger offerTsFileCounter) {
        this.offerTsFileCounter = offerTsFileCounter;
    }
}

