/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexResponseImpl;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class ReadIndexResponseSerializer
implements MessageSerializer<RpcRequests.ReadIndexResponse> {
    public static final ReadIndexResponseSerializer INSTANCE = new ReadIndexResponseSerializer();

    private ReadIndexResponseSerializer() {
    }

    @Override
    public boolean writeMessage(RpcRequests.ReadIndexResponse msg, MessageWriter writer) throws MessageMappingException {
        ReadIndexResponseImpl message = (ReadIndexResponseImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("index", message.index());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeBoolean("success", message.success());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

