/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.message.TxCleanupMessage;
import org.apache.ignite3.internal.tx.message.TxCleanupMessageBuilder;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;

class TxCleanupMessageDeserializer
implements MessageDeserializer<TxCleanupMessage> {
    private final TxCleanupMessageBuilder msg;

    TxCleanupMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txCleanupMessage();
    }

    @Override
    public Class<TxCleanupMessage> klass() {
        return TxCleanupMessage.class;
    }

    @Override
    public TxCleanupMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commit(tmp);
                reader.incrementState();
            }
            case 1: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 2: {
                Comparable<HybridTimestamp> tmp = reader.readList("groups", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groups((List<EnlistedPartitionGroupMessage>)((Object)tmp));
                reader.incrementState();
            }
            case 3: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 4: {
                Comparable<HybridTimestamp> tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxCleanupMessage.class);
    }
}

