/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.network.recovery.message.ProbeMessage;
import org.apache.ignite3.internal.network.recovery.message.ProbeMessageImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class ProbeMessageSerializer
implements MessageSerializer<ProbeMessage> {
    public static final ProbeMessageSerializer INSTANCE = new ProbeMessageSerializer();

    private ProbeMessageSerializer() {
    }

    @Override
    public boolean writeMessage(ProbeMessage msg, MessageWriter writer) throws MessageMappingException {
        ProbeMessageImpl message = (ProbeMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)1)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByte("dummy", message.dummy());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

