/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.debug;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.debug.DebugNode;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class LocalVariableNode
implements DebugNode {
    private final Variable variable;
    private final LabelNode start;
    private final LabelNode end;

    public LocalVariableNode(Variable variable, LabelNode start, LabelNode end) {
        this.variable = variable;
        this.start = start;
        this.end = end;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        visitor.visitLocalVariable(this.variable.getName(), this.variable.getType().getType(), this.variable.getType().getGenericSignature(), this.start.getLabel(), this.end.getLabel(), generationContext.getVariableSlot(this.variable));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{variable=" + String.valueOf(this.variable) + ", start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "}";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitLocalVariable(parent, this);
    }
}

