/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogNotFoundException;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class TableUtils {
    public static List<Integer> indexIdsAtRwTxBeginTs(CatalogService catalogService, UUID txId, int tableId) {
        HybridTimestamp beginTs = TransactionIds.beginTimestamp((UUID)txId);
        Catalog catalog = catalogService.activeCatalog(beginTs.longValue());
        List indexes = catalog.indexes(tableId);
        assert (!indexes.isEmpty()) : String.format("txId=%s, tableId=%s, catalogVersion=%s", txId, tableId, catalog.version());
        return CollectionUtils.view((List)indexes, CatalogObjectDescriptor::id);
    }

    @Nullable
    public static List<Integer> indexIdsAtRwTxBeginTsOrNull(CatalogService catalogService, UUID txId, int tableId) {
        try {
            return TableUtils.indexIdsAtRwTxBeginTs(catalogService, txId, tableId);
        }
        catch (CatalogNotFoundException e) {
            return null;
        }
    }

    static Set<Integer> aliveTables(CatalogService catalogService, @Nullable HybridTimestamp lowWatermark) {
        int oldestAliveVersion = lowWatermark != null ? catalogService.activeCatalogVersion(lowWatermark.longValue()) : catalogService.earliestCatalogVersion();
        HashSet<Integer> ids = new HashSet<Integer>();
        for (int version = oldestAliveVersion; version <= catalogService.latestCatalogVersion(); ++version) {
            for (CatalogTableDescriptor table : catalogService.catalog(version).tables()) {
                ids.add(table.id());
            }
        }
        return Collections.unmodifiableSet(ids);
    }

    public static boolean isDirectFlowApplicable(@Nullable InternalTransaction tx) {
        return tx == null || tx.implicit() && tx.isReadOnly();
    }
}

