/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.AsofJoin;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LogicalAsofJoin
extends AsofJoin {
    private final ImmutableList<RelDataTypeField> systemFieldList;

    public LogicalAsofJoin(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode left, RelNode right, RexNode condition, RexNode matchCondition, JoinRelType joinType, ImmutableList<RelDataTypeField> systemFieldList) {
        super(cluster, traitSet, hints, left, right, condition, matchCondition, (Set<CorrelationId>)ImmutableSet.of(), joinType);
        this.systemFieldList = Objects.requireNonNull(systemFieldList, "systemFieldList");
    }

    public LogicalAsofJoin(RelInput input) {
        this(input.getCluster(), input.getCluster().traitSetOf((RelTrait)Convention.NONE), new ArrayList<RelHint>(), input.getInputs().get(0), input.getInputs().get(1), Objects.requireNonNull(input.getExpression("condition"), "condition"), Objects.requireNonNull(input.getExpression("matchCondition"), "matchCondition"), Objects.requireNonNull(input.getEnum("joinType", JoinRelType.class), "joinType"), (ImmutableList<RelDataTypeField>)ImmutableList.of());
    }

    public static LogicalAsofJoin create(RelNode left, RelNode right, List<RelHint> hints, RexNode condition, RexNode matchCondition, JoinRelType joinType, ImmutableList<RelDataTypeField> systemFieldList) {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE);
        return new LogicalAsofJoin(cluster, traitSet, hints, left, right, condition, matchCondition, joinType, systemFieldList);
    }

    public LogicalAsofJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RexNode matchConditionExpr, RelNode left, RelNode right) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalAsofJoin(this.getCluster(), this.getCluster().traitSetOf((RelTrait)Convention.NONE), (List<RelHint>)this.hints, left, right, conditionExpr, matchConditionExpr, this.joinType, this.systemFieldList);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public boolean deepEquals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        LogicalAsofJoin asofObj = Objects.requireNonNull((LogicalAsofJoin)obj);
        return this.deepEquals0(obj) && this.matchCondition.equals(asofObj.matchCondition) && this.systemFieldList.equals(asofObj.systemFieldList);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(this.deepHashCode0(), this.systemFieldList);
    }

    public ImmutableList<RelDataTypeField> getSystemFieldList() {
        return this.systemFieldList;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        throw new RuntimeException("This method should not be called");
    }

    @Override
    public Join copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return new LogicalAsofJoin(this.getCluster(), traitSet, (List<RelHint>)this.hints, inputs.get(0), inputs.get(1), this.getCondition(), this.getMatchCondition(), this.joinType, this.systemFieldList);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalAsofJoin(this.getCluster(), this.traitSet, hintList, this.left, this.right, this.condition, this.matchCondition, this.joinType, this.systemFieldList);
    }
}

