/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.systemview.api;

import java.util.List;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewColumn;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.StringUtils;

public class NodeSystemView<T>
extends SystemView<T> {
    private final String nodeNameColumnAlias;

    private NodeSystemView(String name, List<SystemViewColumn<T, ?>> columns, Flow.Publisher<T> dataProvider, String nodeNameColumnAlias) {
        super(name, columns, dataProvider);
        if (StringUtils.nullOrBlank((String)nodeNameColumnAlias)) {
            throw new IllegalArgumentException("Node name column alias can not be null or blank");
        }
        if (columns.stream().anyMatch(c -> nodeNameColumnAlias.equals(c.name()))) {
            throw new IllegalArgumentException("Node name column alias must distinct from column names");
        }
        this.nodeNameColumnAlias = nodeNameColumnAlias;
    }

    public String nodeNameColumnAlias() {
        return this.nodeNameColumnAlias;
    }

    public String toString() {
        return S.toString(NodeSystemView.class, (Object)this, (String)"name", (Object)this.name(), (String)"columns", this.columns(), (String)"nodeNameColumnAlias", (Object)this.nodeNameColumnAlias);
    }

    public static class Builder<T>
    extends SystemView.SystemViewBuilder<NodeSystemView<T>, T, Builder<T>> {
        private String nodeNameColumnAlias;

        Builder() {
        }

        public Builder<T> nodeNameColumnAlias(String alias) {
            this.nodeNameColumnAlias = SystemView.normalizeIdentifier(alias);
            return this;
        }

        @Override
        public NodeSystemView<T> build() {
            return new NodeSystemView(this.name, this.columns, this.dataProvider, this.nodeNameColumnAlias);
        }
    }
}

