/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StarRocksSqlDialect
extends MysqlSqlDialect {
    public static final RelDataTypeSystem STARROCKS_TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case CHAR: {
                    return 255;
                }
                case VARCHAR: {
                    return 65533;
                }
                case VARBINARY: {
                    return 0x100000;
                }
            }
            return super.getMaxPrecision(typeName);
        }

        @Override
        public int getDefaultPrecision(SqlTypeName typeName) {
            if (typeName == SqlTypeName.CHAR) {
                return -1;
            }
            return super.getDefaultPrecision(typeName);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.STARROCKS).withIdentifierQuoteString("`").withDataTypeSystem(STARROCKS_TYPE_SYSTEM).withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new StarRocksSqlDialect(DEFAULT_CONTEXT);

    public StarRocksSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return false;
    }

    @Override
    public boolean supportsTimestampPrecision() {
        return false;
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsJoinType(JoinRelType joinType) {
        return true;
    }

    @Override
    public RexNode prepareUnparse(RexNode arg) {
        return RelToSqlConverterUtil.unparseIsTrueOrFalse(arg);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case ARRAY_VALUE_CONSTRUCTOR: {
                SqlWriter.Frame arrayFrame = writer.startList("[", "]");
                for (SqlNode operand : call.getOperandList()) {
                    writer.sep(",");
                    operand.unparse(writer, leftPrec, rightPrec);
                }
                writer.endList(arrayFrame);
                break;
            }
            case MAP_VALUE_CONSTRUCTOR: {
                writer.keyword(call.getOperator().getName());
                SqlWriter.Frame mapFrame = writer.startList("{", "}");
                for (int i = 0; i < call.operandCount(); ++i) {
                    String sep = i % 2 == 0 ? "," : ":";
                    writer.sep(sep);
                    ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
                }
                writer.endList(mapFrame);
                break;
            }
            case TRIM: {
                RelToSqlConverterUtil.unparseHiveTrim(writer, call, leftPrec, rightPrec);
                break;
            }
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                SqlCall newCall = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                SqlFloorFunction.unparseDatetimeFunction(writer, newCall, "DATE_TRUNC", false);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case INTEGER: {
                return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("INT", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            case BIGINT: {
                return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.BIGINT, SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            case TIMESTAMP: {
                return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("DATETIME", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            case VARCHAR: {
                return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.VARCHAR, type.getPrecision(), SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
        }
        return super.getCastSpec(type);
    }

    @Override
    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        if (literal.getTypeName() == SqlTypeName.TIMESTAMP) {
            writer.literal("DATETIME '" + literal.toFormattedString() + "'");
        } else {
            super.unparseDateTimeLiteral(writer, literal, leftPrec, rightPrec);
        }
    }
}

