/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.rules.ImmutableMinusToFilterRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class MinusToFilterRule
extends RelRule<Config>
implements TransformationRule {
    @Deprecated
    protected MinusToFilterRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode leftBase;
        Minus minus = (Minus)call.rel(0);
        if (minus.all || minus.getInputs().size() != 2) {
            return;
        }
        RelBuilder builder = call.builder();
        Object leftInput = call.rel(1);
        Filter rightInput = (Filter)call.rel(2);
        if (!RexUtil.isDeterministic(rightInput.getCondition())) {
            return;
        }
        RexNode leftCond = null;
        if (leftInput instanceof Filter) {
            Filter leftFilter = (Filter)leftInput;
            leftBase = leftFilter.getInput().stripped();
            leftCond = leftFilter.getCondition();
        } else {
            leftBase = leftInput.stripped();
        }
        RelNode rightBase = rightInput.getInput().stripped();
        if (!leftBase.equals(rightBase)) {
            return;
        }
        RexNode finalCond = leftCond != null ? builder.and(leftCond, builder.not(rightInput.getCondition())) : builder.not(rightInput.getCondition());
        builder.push(leftBase).filter(finalCond).distinct();
        call.transformTo(builder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableMinusToFilterRule.Config.of().withOperandFor(Minus.class, RelNode.class, Filter.class);

        @Override
        default public MinusToFilterRule toRule() {
            return new MinusToFilterRule(this);
        }

        default public Config withOperandFor(Class<? extends Minus> minusClass, Class<? extends RelNode> relNodeClass, Class<? extends Filter> filterClass) {
            return this.withOperandSupplier(b0 -> b0.operand(minusClass).inputs(b1 -> b1.operand(relNodeClass).anyInputs(), b2 -> b2.operand(filterClass).anyInputs())).as(Config.class);
        }
    }
}

