/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.handlers;

import java.util.Collection;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partition.replicator.raft.CommandResult;
import org.apache.ignite.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.apache.ignite.internal.tx.message.VacuumTxStatesCommand;
import org.apache.ignite.internal.tx.storage.state.TxStatePartitionStorage;
import org.jetbrains.annotations.Nullable;

public class VacuumTxStatesCommandHandler
extends AbstractCommandHandler<VacuumTxStatesCommand> {
    private final TxStatePartitionStorage txStatePartitionStorage;

    public VacuumTxStatesCommandHandler(TxStatePartitionStorage txStatePartitionStorage) {
        this.txStatePartitionStorage = txStatePartitionStorage;
    }

    @Override
    protected CommandResult handleInternally(VacuumTxStatesCommand command, long commandIndex, long commandTerm, @Nullable HybridTimestamp safeTimestamp) {
        if (commandIndex <= this.txStatePartitionStorage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        this.txStatePartitionStorage.removeAll((Collection)command.txIds(), commandIndex, commandTerm);
        return CommandResult.EMPTY_APPLIED_RESULT;
    }
}

