/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands;

import java.util.Arrays;
import java.util.stream.Collectors;
import picocli.CommandLine;

public class SpacedParameterMixin {
    @CommandLine.Parameters(arity="1")
    private String[] args;

    public String toString() {
        return Arrays.stream(this.args).map(SpacedParameterMixin::unquote).collect(Collectors.joining(" "));
    }

    private static String unquote(String rawString) {
        if (SpacedParameterMixin.isQuoted(rawString, '\"') || SpacedParameterMixin.isQuoted(rawString, '\'') || SpacedParameterMixin.isQuoted(rawString, '`')) {
            return rawString.substring(1, rawString.length() - 1);
        }
        return rawString;
    }

    private static boolean isQuoted(String string, char quoteChar) {
        return string.charAt(0) == quoteChar && string.charAt(string.length() - 1) == quoteChar;
    }
}

