/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags.propagation;

import io.opencensus.implcore.internal.CurrentState;
import io.opencensus.implcore.tags.TagMapImpl;
import io.opencensus.implcore.tags.propagation.BinarySerializationUtils;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.propagation.TagContextBinarySerializer;
import io.opencensus.tags.propagation.TagContextDeserializationException;
import io.opencensus.tags.propagation.TagContextSerializationException;

final class TagContextBinarySerializerImpl
extends TagContextBinarySerializer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final CurrentState state;

    TagContextBinarySerializerImpl(CurrentState state) {
        this.state = state;
    }

    public byte[] toByteArray(TagContext tags) throws TagContextSerializationException {
        return this.state.getInternal() == CurrentState.State.DISABLED ? EMPTY_BYTE_ARRAY : BinarySerializationUtils.serializeBinary(tags);
    }

    public TagContext fromByteArray(byte[] bytes) throws TagContextDeserializationException {
        return this.state.getInternal() == CurrentState.State.DISABLED ? TagMapImpl.EMPTY : BinarySerializationUtils.deserializeBinary(bytes);
    }
}

