/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectTransformerUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public abstract class CacheObjectAdapter
implements CacheObject,
Externalizable {
    private static final long serialVersionUID = 2006765505127197251L;
    protected static final int HEAD_SIZE = 5;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    protected Object val;
    protected byte[] valBytes;

    protected boolean needCopy(CacheObjectValueContext ctx) {
        return ctx.copyOnGet() && this.val != null && !ctx.kernalContext().cacheObjects().immutable(this.val);
    }

    protected byte[] valueBytesFromValue(CacheObjectValueContext ctx) throws IgniteCheckedException {
        byte[] bytes = ctx.kernalContext().cacheObjects().marshal(ctx, this.val);
        return CacheObjectTransformerUtils.transformIfNecessary(bytes, ctx);
    }

    protected Object valueFromValueBytes(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        byte[] bytes = CacheObjectTransformerUtils.restoreIfNecessary(this.valBytes, ctx);
        return ctx.kernalContext().cacheObjects().unmarshal(ctx, bytes, ldr);
    }

    @Override
    public byte cacheObjectType() {
        return 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.valBytes != null);
        U.writeByteArray(out, this.valBytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.valBytes = U.readByteArray(in);
    }

    @Override
    public boolean putValue(ByteBuffer buf) throws IgniteCheckedException {
        assert (this.valBytes != null) : "Value bytes must be initialized before object is stored";
        return this.putValue(buf, 0, CacheObjectAdapter.objectPutSize(this.valBytes.length));
    }

    @Override
    public int putValue(long addr) throws IgniteCheckedException {
        assert (this.valBytes != null) : "Value bytes must be initialized before object is stored";
        return CacheObjectAdapter.putValue(addr, this.cacheObjectType(), this.valBytes);
    }

    public static int putValue(long addr, byte type, byte[] valBytes) {
        return CacheObjectAdapter.putValue(addr, type, valBytes, 0, valBytes.length);
    }

    public static int putValue(long addr, byte type, byte[] srcBytes, int srcOff, int len) {
        int off = 0;
        PageUtils.putInt(addr, off, len);
        PageUtils.putByte(addr, off += 4, type);
        PageUtils.putBytes(addr, ++off, srcBytes, srcOff, len);
        return off += len;
    }

    @Override
    public boolean putValue(ByteBuffer buf, int off, int len) throws IgniteCheckedException {
        assert (this.valBytes != null) : "Value bytes must be initialized before object is stored";
        return CacheObjectAdapter.putValue(this.cacheObjectType(), buf, off, len, this.valBytes, 0);
    }

    @Override
    public int valueBytesLength(CacheObjectContext ctx) throws IgniteCheckedException {
        if (this.valBytes == null) {
            this.valueBytes(ctx);
        }
        return CacheObjectAdapter.objectPutSize(this.valBytes.length);
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.valBytes = reader.readByteArray("valBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheObjectAdapter.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("valBytes", this.valBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return S.toString(S.includeSensitive() ? this.getClass().getSimpleName() : "CacheObject", "val", this.val, true, "hasValBytes", (Object)(this.valBytes != null ? 1 : 0), false);
    }

    public static int objectPutSize(int dataLen) {
        return dataLen + 5;
    }

    public static boolean putValue(byte cacheObjType, ByteBuffer buf, int off, int len, byte[] valBytes, int start) throws IgniteCheckedException {
        int dataLen = valBytes.length;
        if (buf.remaining() < len) {
            return false;
        }
        if (off == 0 && len >= 5) {
            buf.putInt(dataLen);
            buf.put(cacheObjType);
            len -= 5;
        } else if (off >= 5) {
            off -= 5;
        } else {
            ByteBuffer head = ByteBuffer.allocate(5);
            head.order(buf.order());
            head.putInt(dataLen);
            head.put(cacheObjType);
            head.position(off);
            if (len < head.capacity()) {
                head.limit(off + Math.min(len, head.capacity() - off));
            }
            buf.put(head);
            if (head.limit() < 5) {
                return true;
            }
            len -= 5 - off;
            off = 0;
        }
        buf.put(valBytes, start + off, len);
        return true;
    }
}

