/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.jdbc;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.IgniteBenchmarkArguments;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class JdbcAbstractBenchmark
extends IgniteAbstractBenchmark {
    protected final IgniteBenchmarkArguments args = new IgniteBenchmarkArguments();
    private final List<Connection> threadConnections = new ArrayList<Connection>();
    private final List<String> dbqueries = new ArrayList<String>();
    ThreadLocal<Connection> conn = new ThreadLocal<Connection>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Connection initialValue() {
            Connection conn;
            try {
                conn = JdbcAbstractBenchmark.this.connection();
                if (JdbcAbstractBenchmark.this.args.createTempDatabase() || JdbcAbstractBenchmark.this.args.dbn() != null) {
                    assert (JdbcAbstractBenchmark.this.dbName != null);
                    conn.setCatalog(JdbcAbstractBenchmark.this.dbName);
                }
            }
            catch (SQLException e) {
                throw new IgniteException((Throwable)e);
            }
            List<Connection> list = JdbcAbstractBenchmark.this.threadConnections;
            synchronized (list) {
                JdbcAbstractBenchmark.this.threadConnections.add(conn);
            }
            return conn;
        }
    };
    private String dbName;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.jcommander((String[])cfg.commandLineArguments(), (Object)this.args, (String)"<ignite-driver>");
        Class.forName(this.args.jdbcDriver());
        if (this.args.createTempDatabase()) {
            this.createTestDatabase();
        } else {
            this.dbName = this.args.dbn() == null ? null : this.args.dbn();
        }
        try (Connection conn = this.connection();){
            if (this.args.createTempDatabase()) {
                conn.setCatalog(this.dbName);
            }
            this.populateTestDatabase(conn);
        }
        if (this.args.loadTestQueriesFile() != null) {
            this.setQueries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        List<Connection> list = this.threadConnections;
        synchronized (list) {
            for (Connection conn : this.threadConnections) {
                U.closeQuiet((AutoCloseable)conn);
            }
            this.threadConnections.clear();
        }
        if (this.args.createTempDatabase()) {
            this.dropTestDatabase();
        }
        super.tearDown();
    }

    private void createTestDatabase() throws SQLException {
        try (Connection conn = this.connection();){
            String uuid = UUID.randomUUID().toString().replace("-", "");
            this.dbName = "benchmark" + ((Object)((Object)this)).getClass().getSimpleName() + uuid.substring(0, 16);
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate("create database " + this.dbName);
            }
        }
    }

    private void dropTestDatabase() throws SQLException {
        try (Connection conn = this.connection();
             Statement stmt = conn.createStatement();){
            if (!conn.getMetaData().getDatabaseProductName().equals("Apache Ignite")) {
                stmt.executeUpdate("drop database " + this.dbName);
            }
        }
    }

    private void populateTestDatabase(Connection conn) throws IOException, SQLException {
        assert (conn != null);
        ArrayList<String> queries = new ArrayList<String>();
        if (this.args.schemaDefinition() != null) {
            try (FileReader fr = new FileReader(this.args.schemaDefinition());
                 BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    queries.add(line.trim());
                }
            }
        }
        for (String qry : queries) {
            PreparedStatement stmt = conn.prepareStatement(qry);
            try {
                stmt.executeUpdate();
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
            }
        }
    }

    private void setQueries() throws IOException, SQLException {
        if (this.args.loadTestQueriesFile() != null) {
            try (FileReader fr = new FileReader(this.args.loadTestQueriesFile());
                 BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    this.dbqueries.add(line.trim());
                }
            }
        }
    }

    public Connection connection() throws SQLException {
        Connection conn = DriverManager.getConnection(this.args.jdbcUrl());
        conn.setAutoCommit(true);
        return conn;
    }

    public List<String> getDbqueries() {
        return this.dbqueries;
    }

    void clearTable(String tblName) throws SQLException {
        try (Connection conn = this.connection();
             PreparedStatement stmt = conn.prepareStatement("drop table " + tblName);){
            if (!conn.getMetaData().getDatabaseProductName().equals("Apache Ignite")) {
                stmt.executeUpdate();
            }
        }
    }
}

