/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.List;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridAffinityFunctionContextImpl
implements AffinityFunctionContext {
    private final List<ClusterNode> topSnapshot;
    private final List<List<ClusterNode>> prevAssignment;
    private final DiscoveryEvent discoEvt;
    private final AffinityTopologyVersion topVer;
    private final int backups;

    public GridAffinityFunctionContextImpl(List<ClusterNode> topSnapshot, List<List<ClusterNode>> prevAssignment, DiscoveryEvent discoEvt, @NotNull AffinityTopologyVersion topVer, int backups) {
        this.topSnapshot = topSnapshot;
        this.prevAssignment = prevAssignment;
        this.discoEvt = discoEvt;
        this.topVer = topVer;
        this.backups = backups;
    }

    @Override
    @Nullable
    public List<ClusterNode> previousAssignment(int part) {
        return this.prevAssignment == null ? null : this.prevAssignment.get(part);
    }

    @Override
    public List<ClusterNode> currentTopologySnapshot() {
        return this.topSnapshot;
    }

    @Override
    public AffinityTopologyVersion currentTopologyVersion() {
        return this.topVer;
    }

    @Override
    @Nullable
    public DiscoveryEvent discoveryEvent() {
        return this.discoEvt;
    }

    @Override
    public int backups() {
        return this.backups;
    }

    public List<List<ClusterNode>> prevAssignment() {
        return this.prevAssignment;
    }
}

