/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.checkpoint;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCheckpointRequest
implements Message {
    private static final long serialVersionUID = 0L;
    private IgniteUuid sesId;
    @GridToStringInclude(sensitive=true)
    private String key;
    private String cpSpi;

    public GridCheckpointRequest() {
    }

    public GridCheckpointRequest(IgniteUuid sesId, String key, String cpSpi) {
        assert (sesId != null);
        assert (key != null);
        this.sesId = sesId;
        this.key = key;
        this.cpSpi = cpSpi == null || cpSpi.isEmpty() ? null : cpSpi;
    }

    public IgniteUuid getSessionId() {
        return this.sesId;
    }

    public String getKey() {
        return this.key;
    }

    public String getCheckpointSpi() {
        return this.cpSpi;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("cpSpi", this.cpSpi)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeString("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeIgniteUuid("sesId", this.sesId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cpSpi = reader.readString("cpSpi");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.key = reader.readString("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.sesId = reader.readIgniteUuid("sesId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCheckpointRequest.class);
    }

    @Override
    public short directType() {
        return 7;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    public String toString() {
        return S.toString(GridCheckpointRequest.class, this);
    }
}

