/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderListener;
import org.testng.ListenerComparator;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.IConfiguration;

public class DataProviderHolder {
    private final Map<Class<?>, IDataProviderListener> listeners = Maps.newConcurrentMap();
    private final Collection<IDataProviderInterceptor> interceptors = Sets.newHashSet();
    private final ListenerComparator listenerComparator;

    public DataProviderHolder(IConfiguration configuration) {
        this.listenerComparator = Objects.requireNonNull(configuration).getListenerComparator();
    }

    public Collection<IDataProviderListener> getListeners() {
        return ListenerComparator.sort(this.listeners.values(), this.listenerComparator);
    }

    public Collection<IDataProviderInterceptor> getInterceptors() {
        return ListenerComparator.sort(this.interceptors, this.listenerComparator);
    }

    public void addListeners(Collection<IDataProviderListener> listeners) {
        listeners.forEach(this::addListener);
    }

    public void addListener(IDataProviderListener listener) {
        this.listeners.putIfAbsent(listener.getClass(), listener);
    }

    public void addInterceptors(Collection<IDataProviderInterceptor> interceptors) {
        interceptors.forEach(this::addInterceptor);
    }

    public void addInterceptor(IDataProviderInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void merge(DataProviderHolder other) {
        this.addListeners(other.getListeners());
        this.interceptors.addAll(other.getInterceptors());
    }
}

