/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.visitor.check;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulator.ManipulationResultVisitor;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.util.Metadatas;
import org.apache.felix.ipojo.manipulator.visitor.ManipulationResultAdapter;
import org.apache.felix.ipojo.metadata.Element;

public class CheckFieldConsistencyResultVisitor
extends ManipulationResultAdapter {
    private Element m_metadata;
    private Reporter m_reporter;

    public CheckFieldConsistencyResultVisitor(ManipulationResultVisitor visitor) {
        super(visitor);
    }

    public void setMetadata(Element metadata) {
        this.m_metadata = metadata;
    }

    public void setReporter(Reporter reporter) {
        this.m_reporter = reporter;
    }

    @Override
    public void visitClassStructure(Element structure) {
        ArrayList<String> fieldsInStructure = new ArrayList<String>();
        this.collectStructuralFields(fieldsInStructure, structure);
        ArrayList<String> fieldsInMetadata = new ArrayList<String>();
        Metadatas.findFields(fieldsInMetadata, this.m_metadata);
        this.checkReferredFieldsAreInStructure(fieldsInMetadata, fieldsInStructure);
        super.visitClassStructure(structure);
    }

    private void collectStructuralFields(List<String> fieldsInStructure, Element structure) {
        Element[] fields = structure.getElements("field");
        if (fields != null) {
            for (Element field : fields) {
                fieldsInStructure.add(field.getAttribute("name"));
            }
        }
    }

    private void checkReferredFieldsAreInStructure(List<String> fieldsInMetadata, List<String> fieldsInStructure) {
        for (String fieldName : fieldsInMetadata) {
            if (fieldsInStructure.contains(fieldName)) continue;
            this.m_reporter.error("The field " + fieldName + " is referenced in the metadata but does not exist in the " + Metadatas.getComponentType(this.m_metadata) + " class", new Object[0]);
        }
    }
}

