/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.feature.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.osgi.service.feature.FeatureArtifact;
import org.osgi.service.feature.FeatureExtension;
import org.osgi.service.feature.FeatureExtensionBuilder;

class ExtensionBuilderImpl
implements FeatureExtensionBuilder {
    private final String name;
    private final FeatureExtension.Type type;
    private final FeatureExtension.Kind kind;
    private final List<String> content = new ArrayList<String>();
    private final List<FeatureArtifact> artifacts = new ArrayList<FeatureArtifact>();

    ExtensionBuilderImpl(String name, FeatureExtension.Type type, FeatureExtension.Kind kind) {
        this.name = name;
        this.type = type;
        this.kind = kind;
    }

    public FeatureExtensionBuilder addText(String text) {
        if (this.type != FeatureExtension.Type.TEXT) {
            throw new IllegalStateException("Cannot add text to extension of type " + this.type);
        }
        this.content.add(text);
        return this;
    }

    public FeatureExtensionBuilder setJSON(String json) {
        if (this.type != FeatureExtension.Type.JSON) {
            throw new IllegalStateException("Cannot add text to extension of type " + this.type);
        }
        this.content.clear();
        this.content.add(json);
        return this;
    }

    public FeatureExtensionBuilder addArtifact(FeatureArtifact art) {
        if (this.type != FeatureExtension.Type.ARTIFACTS) {
            throw new IllegalStateException("Cannot add artifacts to extension of type " + this.type);
        }
        this.artifacts.add(art);
        return this;
    }

    public FeatureExtension build() {
        return new ExtensionImpl(this.name, this.type, this.kind, this.content, this.artifacts);
    }

    private static class ExtensionImpl
    implements FeatureExtension {
        private final String name;
        private final FeatureExtension.Type type;
        private final FeatureExtension.Kind kind;
        private final List<String> content;
        private final List<FeatureArtifact> artifacts;

        private ExtensionImpl(String name, FeatureExtension.Type type, FeatureExtension.Kind kind, List<String> content, List<FeatureArtifact> artifacts) {
            this.name = name;
            this.type = type;
            this.kind = kind;
            this.content = Collections.unmodifiableList(content);
            this.artifacts = Collections.unmodifiableList(artifacts);
        }

        public String getName() {
            return this.name;
        }

        public FeatureExtension.Type getType() {
            return this.type;
        }

        public FeatureExtension.Kind getKind() {
            return this.kind;
        }

        public String getJSON() {
            if (this.type != FeatureExtension.Type.JSON) {
                throw new IllegalStateException("Extension is not of type JSON " + this.type);
            }
            if (this.content.isEmpty()) {
                return null;
            }
            return this.content.get(0);
        }

        public List<String> getText() {
            if (this.type != FeatureExtension.Type.TEXT) {
                throw new IllegalStateException("Extension is not of type Text " + this.type);
            }
            return this.content;
        }

        public List<FeatureArtifact> getArtifacts() {
            if (this.type != FeatureExtension.Type.ARTIFACTS) {
                throw new IllegalStateException("Extension is not of type Text " + this.type);
            }
            return this.artifacts;
        }

        public int hashCode() {
            return Objects.hash(this.artifacts, this.content, this.kind, this.name, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtensionImpl other = (ExtensionImpl)obj;
            return Objects.equals(this.artifacts, other.artifacts) && Objects.equals(this.content, other.content) && this.kind == other.kind && Objects.equals(this.name, other.name) && this.type == other.type;
        }

        public String toString() {
            return "ExtensionImpl [name=" + this.name + ", type=" + this.type + "]";
        }
    }
}

