/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.util.ArrayList;
import java.util.List;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.source.SourceTransformerSaxHandler;
import org.apache.torque.generator.source.SourceProcessConfiguration;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.SourceTransformerDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SourceSaxHandler
extends DefaultHandler {
    private ConfigurationProvider configurationProvider;
    private ProjectPaths projectPaths;
    private ConfigurationHandlers configurationHandlers;
    private SourceProcessConfiguration sourceProcessConfiguration;
    private List<SourceTransformerDefinition> transformerDefinitions = new ArrayList<SourceTransformerDefinition>();
    private SourceTransformerSaxHandler transformerSaxHandler;
    private boolean finished = false;

    public SourceSaxHandler(ConfigurationProvider configurationProvider, ProjectPaths projectPaths, ConfigurationHandlers configurationHandlers) {
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths must not be null");
        }
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers must not be null");
        }
        this.configurationProvider = configurationProvider;
        this.projectPaths = projectPaths;
        this.configurationHandlers = configurationHandlers;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (this.transformerSaxHandler != null) {
            this.transformerSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if ("transformer".equals(rawName)) {
            this.transformerSaxHandler = new SourceTransformerSaxHandler(this.configurationProvider, this.projectPaths);
            this.transformerSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if (rawName.equals("source")) {
            this.sourceProcessConfiguration = new SourceProcessConfiguration();
            this.sourceProcessConfiguration.setStartElementsPath(attributes.getValue("elements"));
            try {
                this.sourceProcessConfiguration.setSkipDecider(attributes.getValue("skipDecider"));
            }
            catch (ConfigurationException e) {
                throw new SAXException("Could not create source: " + e.getMessage(), e);
            }
        } else {
            throw new SAXException("Unknown element " + rawName);
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (this.transformerSaxHandler != null) {
            this.transformerSaxHandler.endElement(uri, localName, rawName);
            if (this.transformerSaxHandler.isFinished()) {
                this.transformerDefinitions.add(new SourceTransformerDefinition(this.transformerSaxHandler.getSourceTransformer(), this.transformerSaxHandler.getElements()));
                this.transformerSaxHandler = null;
            }
        } else if (rawName.equals("source")) {
            this.sourceProcessConfiguration.setSourceTransformerDefinitions(this.transformerDefinitions);
            this.transformerDefinitions = new ArrayList<SourceTransformerDefinition>();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.transformerSaxHandler != null) {
            this.transformerSaxHandler.characters(ch, start, length);
        }
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public ConfigurationHandlers getConfigurationHandlers() {
        return this.configurationHandlers;
    }

    public ProjectPaths getProjectPaths() {
        return this.projectPaths;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected void finished() {
        this.finished = true;
    }

    public abstract SourceProvider getSourceProvider();

    public SourceProcessConfiguration getSourceProcessConfiguration() {
        return this.sourceProcessConfiguration;
    }
}

