/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.helpers;

import com.siemens.ct.exi.core.CodingMode;
import com.siemens.ct.exi.core.DecodingOptions;
import com.siemens.ct.exi.core.EXIBodyDecoder;
import com.siemens.ct.exi.core.EXIBodyEncoder;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.EXIStreamDecoder;
import com.siemens.ct.exi.core.EXIStreamEncoder;
import com.siemens.ct.exi.core.EncodingOptions;
import com.siemens.ct.exi.core.FidelityOptions;
import com.siemens.ct.exi.core.SchemaIdResolver;
import com.siemens.ct.exi.core.SelfContainedHandler;
import com.siemens.ct.exi.core.coder.EXIBodyDecoderInOrder;
import com.siemens.ct.exi.core.coder.EXIBodyDecoderInOrderSC;
import com.siemens.ct.exi.core.coder.EXIBodyDecoderReordered;
import com.siemens.ct.exi.core.coder.EXIBodyEncoderInOrder;
import com.siemens.ct.exi.core.coder.EXIBodyEncoderInOrderSC;
import com.siemens.ct.exi.core.coder.EXIBodyEncoderReordered;
import com.siemens.ct.exi.core.coder.EXIStreamDecoderImpl;
import com.siemens.ct.exi.core.coder.EXIStreamEncoderImpl;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.strings.BoundedStringDecoderImpl;
import com.siemens.ct.exi.core.datatype.strings.BoundedStringEncoderImpl;
import com.siemens.ct.exi.core.datatype.strings.StringDecoder;
import com.siemens.ct.exi.core.datatype.strings.StringDecoderImpl;
import com.siemens.ct.exi.core.datatype.strings.StringEncoder;
import com.siemens.ct.exi.core.datatype.strings.StringEncoderImpl;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.exceptions.UnsupportedOption;
import com.siemens.ct.exi.core.grammars.Grammars;
import com.siemens.ct.exi.core.grammars.SchemaInformedGrammars;
import com.siemens.ct.exi.core.grammars.SchemaLessGrammars;
import com.siemens.ct.exi.core.types.AbstractTypeDecoder;
import com.siemens.ct.exi.core.types.AbstractTypeEncoder;
import com.siemens.ct.exi.core.types.LexicalTypeDecoder;
import com.siemens.ct.exi.core.types.LexicalTypeEncoder;
import com.siemens.ct.exi.core.types.StringTypeDecoder;
import com.siemens.ct.exi.core.types.StringTypeEncoder;
import com.siemens.ct.exi.core.types.TypeDecoder;
import com.siemens.ct.exi.core.types.TypeEncoder;
import com.siemens.ct.exi.core.types.TypedTypeDecoder;
import com.siemens.ct.exi.core.types.TypedTypeEncoder;
import com.siemens.ct.exi.core.util.sort.QNameSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class DefaultEXIFactory
implements EXIFactory {
    protected Grammars grammar;
    protected boolean isFragment;
    protected CodingMode codingMode;
    protected FidelityOptions fidelityOptions;
    protected EncodingOptions encodingOptions;
    protected DecodingOptions decodingOptions;
    protected SchemaIdResolver schemaIdResolver;
    protected QName[] dtrMapTypes;
    protected QName[] dtrMapRepresentations;
    protected Map<QName, Datatype> dtrMapRepresentationsDatatype;
    protected QName[] scElements;
    protected SelfContainedHandler scHandler;
    protected int blockSize = 1000000;
    protected int valueMaxLength = -1;
    protected int valuePartitionCapacity = -1;
    protected boolean localValuePartitions = true;
    protected int maximumNumberOfBuiltInElementGrammars = -1;
    protected int maximumNumberOfBuiltInProductions = -1;
    protected boolean grammarLearningDisabled = false;
    protected List<String> sharedStrings;
    protected boolean isUsingNonEvolvingGrammrs;
    protected static final QNameSort qnameSort = new QNameSort();

    protected DefaultEXIFactory() {
    }

    protected static void setDefaultValues(EXIFactory factory) {
        factory.setFidelityOptions(FidelityOptions.createDefault());
        factory.setEncodingOptions(EncodingOptions.createDefault());
        factory.setDecodingOptions(DecodingOptions.createDefault());
        factory.setCodingMode(CodingMode.BIT_PACKED);
        factory.setFragment(false);
        factory.setGrammars(new SchemaLessGrammars());
    }

    public static EXIFactory newInstance() {
        DefaultEXIFactory factory = new DefaultEXIFactory();
        DefaultEXIFactory.setDefaultValues(factory);
        return factory;
    }

    @Override
    public void setFidelityOptions(FidelityOptions fidelityOptions) {
        this.fidelityOptions = fidelityOptions;
    }

    @Override
    public FidelityOptions getFidelityOptions() {
        return this.fidelityOptions;
    }

    @Override
    public void setEncodingOptions(EncodingOptions encodingOptions) {
        this.encodingOptions = encodingOptions;
    }

    @Override
    public EncodingOptions getEncodingOptions() {
        return this.encodingOptions;
    }

    @Override
    public void setDecodingOptions(DecodingOptions decodingOptions) {
        this.decodingOptions = decodingOptions;
    }

    @Override
    public DecodingOptions getDecodingOptions() {
        return this.decodingOptions;
    }

    @Override
    public void setSchemaIdResolver(SchemaIdResolver schemaIdResolver) {
        this.schemaIdResolver = schemaIdResolver;
    }

    @Override
    public SchemaIdResolver getSchemaIdResolver() {
        return this.schemaIdResolver;
    }

    @Override
    public void setDatatypeRepresentationMap(QName[] dtrMapTypes, QName[] dtrMapRepresentations) {
        if (dtrMapTypes == null || dtrMapRepresentations == null || dtrMapTypes.length != dtrMapRepresentations.length || dtrMapTypes.length == 0) {
            this.dtrMapTypes = null;
            this.dtrMapRepresentations = null;
        } else {
            this.dtrMapTypes = dtrMapTypes;
            this.dtrMapRepresentations = dtrMapRepresentations;
        }
    }

    @Override
    public Datatype registerDatatypeRepresentationMapDatatype(QName dtrMapRepresentation, Datatype datatype) {
        if (this.dtrMapRepresentationsDatatype == null) {
            this.dtrMapRepresentationsDatatype = new HashMap<QName, Datatype>();
        }
        return this.dtrMapRepresentationsDatatype.put(dtrMapRepresentation, datatype);
    }

    @Override
    public QName[] getDatatypeRepresentationMapTypes() {
        return this.dtrMapTypes;
    }

    @Override
    public QName[] getDatatypeRepresentationMapRepresentations() {
        return this.dtrMapRepresentations;
    }

    @Override
    public void setSelfContainedElements(QName[] scElements) {
        this.setSelfContainedElements(scElements, null);
    }

    @Override
    public void setSelfContainedElements(QName[] scElements, SelfContainedHandler scHandler) {
        this.scElements = scElements;
        this.scHandler = scHandler;
    }

    @Override
    public boolean isSelfContainedElement(QName element) {
        assert (element != null);
        String elementNS = element.getNamespaceURI();
        String elementLP = element.getLocalPart();
        if (this.scElements != null && this.scElements.length > 0) {
            for (int i = 0; i < this.scElements.length; ++i) {
                QName qname = this.scElements[i];
                assert (qname != null);
                if (!elementNS.matches(qname.getNamespaceURI()) || !elementLP.matches(qname.getLocalPart())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SelfContainedHandler getSelfContainedHandler() {
        return this.scHandler;
    }

    @Override
    public void setGrammars(Grammars grammar) {
        assert (grammar != null);
        this.grammar = grammar;
    }

    @Override
    public Grammars getGrammars() {
        return this.grammar;
    }

    protected boolean isSchemaInformed() {
        return this.grammar.isSchemaInformed();
    }

    @Override
    public void setFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }

    @Override
    public boolean isFragment() {
        return this.isFragment;
    }

    @Override
    public void setCodingMode(CodingMode codingMode) {
        this.codingMode = codingMode;
    }

    @Override
    public CodingMode getCodingMode() {
        return this.codingMode;
    }

    @Override
    public void setBlockSize(int blockSize) {
        if (blockSize < 0) {
            throw new RuntimeException("EXI's blockSize has the be a positive number!");
        }
        this.blockSize = blockSize;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void setValueMaxLength(int valueMaxLength) {
        this.valueMaxLength = valueMaxLength;
    }

    @Override
    public int getValueMaxLength() {
        return this.valueMaxLength;
    }

    @Override
    public void setValuePartitionCapacity(int valuePartitionCapacity) {
        this.valuePartitionCapacity = valuePartitionCapacity;
    }

    @Override
    public int getValuePartitionCapacity() {
        return this.valuePartitionCapacity;
    }

    @Override
    public void setLocalValuePartitions(boolean useLocalValuePartitions) {
        this.localValuePartitions = useLocalValuePartitions;
    }

    @Override
    public boolean isLocalValuePartitions() {
        return this.localValuePartitions;
    }

    @Override
    public void setMaximumNumberOfBuiltInElementGrammars(int maximumNumberOfBuiltInElementGrammars) {
        this.maximumNumberOfBuiltInElementGrammars = maximumNumberOfBuiltInElementGrammars >= 0 ? maximumNumberOfBuiltInElementGrammars : -1;
        this.checkGrammarLearningDisabled();
    }

    @Override
    public int getMaximumNumberOfBuiltInElementGrammars() {
        return this.maximumNumberOfBuiltInElementGrammars;
    }

    @Override
    public void setMaximumNumberOfBuiltInProductions(int maximumNumberOfBuiltInProductions) {
        this.maximumNumberOfBuiltInProductions = maximumNumberOfBuiltInProductions >= 0 ? maximumNumberOfBuiltInProductions : -1;
        this.checkGrammarLearningDisabled();
    }

    @Override
    public int getMaximumNumberOfBuiltInProductions() {
        return this.maximumNumberOfBuiltInProductions;
    }

    private void checkGrammarLearningDisabled() {
        this.grammarLearningDisabled = this.maximumNumberOfBuiltInElementGrammars >= 0 || this.maximumNumberOfBuiltInProductions >= 0;
    }

    @Override
    public boolean isGrammarLearningDisabled() {
        return this.grammarLearningDisabled;
    }

    @Override
    public void setSharedStrings(List<String> sharedStrings) {
        this.sharedStrings = sharedStrings;
    }

    @Override
    public List<String> getSharedStrings() {
        return this.sharedStrings;
    }

    @Override
    public void setUsingNonEvolvingGrammars(boolean isNonEvolving) {
        this.isUsingNonEvolvingGrammrs = isNonEvolving;
    }

    @Override
    public boolean isUsingNonEvolvingGrammars() {
        return this.isUsingNonEvolvingGrammrs;
    }

    protected void doSanityCheck() throws EXIException {
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED") && (this.codingMode == CodingMode.COMPRESSION || this.codingMode == CodingMode.PRE_COMPRESSION)) {
            throw new EXIException("(Pre-)Compression and selfContained elements cannot work together");
        }
        if (!this.grammar.isSchemaInformed()) {
            this.maximumNumberOfBuiltInElementGrammars = -1;
            this.maximumNumberOfBuiltInProductions = -1;
            this.grammarLearningDisabled = false;
        }
        if (this.getEncodingOptions().isOptionEnabled("http://www.w3.org/TR/exi-c14n")) {
            this.updateFactoryAccordingCanonicalEXI();
        }
    }

    @Override
    public EXIBodyEncoder createEXIBodyEncoder() throws EXIException {
        this.doSanityCheck();
        if (this.codingMode == CodingMode.COMPRESSION || this.codingMode == CodingMode.PRE_COMPRESSION) {
            return new EXIBodyEncoderReordered(this);
        }
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            return new EXIBodyEncoderInOrderSC(this);
        }
        return new EXIBodyEncoderInOrder(this);
    }

    @Override
    public EXIStreamEncoder createEXIStreamEncoder() throws EXIException {
        this.doSanityCheck();
        return new EXIStreamEncoderImpl(this);
    }

    protected void updateFactoryAccordingCanonicalEXI() throws UnsupportedOption {
        this.getEncodingOptions().unsetOption("INCLUDE_COOKIE");
        if (this.getCodingMode() == CodingMode.COMPRESSION) {
            this.setCodingMode(CodingMode.PRE_COMPRESSION);
        }
        if (this.dtrMapTypes != null && this.dtrMapTypes.length > 0) {
            this.bubbleSort(this.dtrMapTypes, this.dtrMapRepresentations);
        }
    }

    protected void bubbleSort(QName[] dtrMapTypes, QName[] dtrMapRepresentations) {
        boolean swapped = true;
        int j = 0;
        while (swapped) {
            swapped = false;
            ++j;
            for (int i = 0; i < dtrMapTypes.length - j; ++i) {
                if (qnameSort.compare(dtrMapTypes[i], dtrMapTypes[i + 1]) <= 0) continue;
                QName tmpType = dtrMapTypes[i];
                dtrMapTypes[i] = dtrMapTypes[i + 1];
                dtrMapTypes[i + 1] = tmpType;
                QName tmpRep = dtrMapRepresentations[i];
                dtrMapRepresentations[i] = dtrMapRepresentations[i + 1];
                dtrMapRepresentations[i + 1] = tmpRep;
                swapped = true;
            }
        }
    }

    @Override
    public EXIBodyDecoder createEXIBodyDecoder() throws EXIException {
        this.doSanityCheck();
        if (this.codingMode == CodingMode.COMPRESSION || this.codingMode == CodingMode.PRE_COMPRESSION) {
            return new EXIBodyDecoderReordered(this);
        }
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            return new EXIBodyDecoderInOrderSC(this);
        }
        return new EXIBodyDecoderInOrder(this);
    }

    @Override
    public EXIStreamDecoder createEXIStreamDecoder() throws EXIException {
        this.doSanityCheck();
        return new EXIStreamDecoderImpl(this);
    }

    @Override
    public StringEncoder createStringEncoder() {
        StringEncoderImpl stringEncoder = this.getValueMaxLength() != -1 || this.getValuePartitionCapacity() != -1 ? new BoundedStringEncoderImpl(this.isLocalValuePartitions(), this.getValueMaxLength(), this.getValuePartitionCapacity()) : new StringEncoderImpl(this.isLocalValuePartitions());
        return stringEncoder;
    }

    @Override
    public StringDecoder createStringDecoder() {
        StringDecoderImpl stringDecoder = this.getValueMaxLength() != -1 || this.getValuePartitionCapacity() != -1 ? new BoundedStringDecoderImpl(this.isLocalValuePartitions(), this.getValueMaxLength(), this.getValuePartitionCapacity()) : new StringDecoderImpl(this.isLocalValuePartitions());
        return stringDecoder;
    }

    @Override
    public TypeEncoder createTypeEncoder() throws EXIException {
        AbstractTypeEncoder typeEncoder;
        if (this.isSchemaInformed()) {
            this.checkDtrMap();
            if (this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES")) {
                typeEncoder = new LexicalTypeEncoder(this.dtrMapTypes, this.dtrMapRepresentations, this.dtrMapRepresentationsDatatype);
            } else {
                boolean doNormalize = this.getEncodingOptions().isOptionEnabled("UTC_TIME");
                typeEncoder = new TypedTypeEncoder(this.dtrMapTypes, this.dtrMapRepresentations, this.dtrMapRepresentationsDatatype, doNormalize);
            }
        } else {
            typeEncoder = new StringTypeEncoder();
        }
        return typeEncoder;
    }

    private void checkDtrMap() throws EXIException {
        if (this.dtrMapTypes == null) {
            this.dtrMapRepresentations = null;
        } else if (this.dtrMapRepresentations == null || this.dtrMapTypes.length != this.dtrMapRepresentations.length) {
            throw new EXIException("Number of arguments for DTR map must match.");
        }
    }

    @Override
    public TypeDecoder createTypeDecoder() throws EXIException {
        AbstractTypeDecoder typeDecoder;
        if (this.isSchemaInformed()) {
            this.checkDtrMap();
            typeDecoder = this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES") ? new LexicalTypeDecoder(this.dtrMapTypes, this.dtrMapRepresentations, this.dtrMapRepresentationsDatatype) : new TypedTypeDecoder(this.dtrMapTypes, this.dtrMapRepresentations, this.dtrMapRepresentationsDatatype);
        } else {
            typeDecoder = new StringTypeDecoder();
        }
        return typeDecoder;
    }

    @Override
    public EXIFactory clone() {
        try {
            EXIFactory copy = (EXIFactory)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof EXIFactory) {
            EXIFactory other = (EXIFactory)o;
            if (!this.fidelityOptions.equals(other.getFidelityOptions())) {
                return false;
            }
            if (this.isFragment != other.isFragment()) {
                return false;
            }
            if (!Arrays.equals(this.dtrMapTypes, other.getDatatypeRepresentationMapTypes()) || !Arrays.equals(this.dtrMapRepresentations, other.getDatatypeRepresentationMapRepresentations())) {
                return false;
            }
            if (this.getCodingMode() != other.getCodingMode()) {
                return false;
            }
            if (this.getBlockSize() != other.getBlockSize()) {
                return false;
            }
            if (this.getValueMaxLength() != other.getValueMaxLength()) {
                return false;
            }
            return this.getValuePartitionCapacity() == other.getValuePartitionCapacity();
        }
        return false;
    }

    public int hashCode() {
        return this.fidelityOptions.hashCode() ^ (this.isFragment ? 1 : 0) ^ this.codingMode.hashCode() ^ this.blockSize ^ this.valueMaxLength ^ this.valuePartitionCapacity;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.grammar.isSchemaInformed()) {
            SchemaInformedGrammars sig = (SchemaInformedGrammars)this.grammar;
            sb.append("[Schema-Informed=" + sig.getSchemaId() + "]");
        } else {
            sb.append("[Schema-Less]");
        }
        sb.append("[" + (Object)((Object)this.codingMode) + "]");
        sb.append(this.fidelityOptions.toString());
        if (this.isFragment()) {
            sb.append("[Fragment]");
        }
        if (this.dtrMapTypes != null && this.dtrMapTypes.length > 0) {
            int i;
            sb.append("[DTR Types=");
            for (i = 0; i < this.dtrMapTypes.length; ++i) {
                QName dtrMapType = this.dtrMapTypes[i];
                sb.append(dtrMapType + " ");
            }
            sb.append(", Representation=");
            for (i = 0; i < this.dtrMapRepresentations.length; ++i) {
                QName dtrMapRepresentation = this.dtrMapRepresentations[i];
                sb.append(dtrMapRepresentation + " ");
            }
            sb.append("]");
        }
        if (this.scElements != null && this.scElements.length > 0) {
            sb.append("[SCElements=");
            for (int i = 0; i < this.scElements.length; ++i) {
                QName scElement = this.scElements[i];
                sb.append(scElement + " ");
            }
            sb.append("]");
        }
        if (this.blockSize != 1000000) {
            sb.append("[blockSize=" + this.blockSize + "]");
        }
        if (this.valueMaxLength != -1) {
            sb.append("[valueMaxLength=" + this.valueMaxLength + "]");
        }
        if (this.valuePartitionCapacity != -1) {
            sb.append("[valuePartitionCapacity=" + this.valuePartitionCapacity + "]");
        }
        if (!this.isLocalValuePartitions()) {
            sb.append("[localValuePartitions=" + this.isLocalValuePartitions() + "]");
        }
        if (this.getMaximumNumberOfBuiltInProductions() >= 0) {
            sb.append("[maximumNumberOfBuiltInProductions=" + this.getMaximumNumberOfBuiltInProductions() + "]");
        }
        if (this.getMaximumNumberOfBuiltInElementGrammars() >= 0) {
            sb.append("[maximumNumberOfEvolvingBuiltInElementGrammars=" + this.getMaximumNumberOfBuiltInElementGrammars() + "]");
        }
        return sb.toString();
    }
}

