/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConnectionFactoryOptions options;
    private final ActiveMQConnection connection;
    private final SimpleString connID;
    private final ClientProducer clientProducer;
    private final ActiveMQSession session;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private int defaultDeliveryMode = 2;
    private long defaultDeliveryDelay = 0L;
    private final ActiveMQDestination defaultDestination;

    protected ActiveMQMessageProducer(ActiveMQConnection connection, ClientProducer producer, ActiveMQDestination defaultDestination, ActiveMQSession session, ConnectionFactoryOptions options) throws JMSException {
        this.options = options;
        this.connection = connection;
        this.connID = connection.getClientID() != null ? SimpleString.of((String)connection.getClientID()) : connection.getUID();
        this.clientProducer = producer;
        this.defaultDestination = defaultDestination;
        this.session = session;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        if (deliveryMode != 1 && deliveryMode != 2) {
            throw ActiveMQJMSClientBundle.BUNDLE.illegalDeliveryMode(deliveryMode);
        }
        this.defaultDeliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        if (defaultPriority < 0 || defaultPriority > 9) {
            throw new JMSException("Illegal priority value: " + defaultPriority);
        }
        this.defaultPriority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.defaultDestination;
    }

    public void close() throws JMSException {
        this.connection.getThreadAwareContext().assertNotCompletionListenerThread();
        try {
            this.clientProducer.close();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void send(Message message) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, null);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        this.checkDestination(destination);
        this.doSendx((ActiveMQDestination)destination, message, deliveryMode, priority, timeToLive, null);
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.defaultDeliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() throws JMSException {
        return this.defaultDeliveryDelay;
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        this.send(message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkCompletionListener(completionListener);
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkClosed();
        this.checkCompletionListener(completionListener);
        this.checkDestination(destination);
        this.doSendx((ActiveMQDestination)destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination((Destination)topic);
        this.doSendx((ActiveMQDestination)topic, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination((Destination)queue);
        this.doSendx((ActiveMQDestination)queue, message, deliveryMode, priority, timeToLive, null);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public String toString() {
        return "ActiveMQMessageProducer->" + String.valueOf(this.clientProducer);
    }

    private void checkDefaultDestination() {
        if (this.defaultDestination == null) {
            throw new UnsupportedOperationException("Producer does not have a default destination");
        }
    }

    private void checkDestination(Destination destination) throws InvalidDestinationException {
        if (destination != null && !(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Foreign destination:" + String.valueOf(destination));
        }
        if (destination != null && this.defaultDestination != null) {
            throw new UnsupportedOperationException("Cannot specify destination if producer has a default destination");
        }
        if (destination == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullTopic();
        }
    }

    private void checkCompletionListener(CompletionListener completionListener) {
        if (completionListener == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullArgumentNotAllowed("CompletionListener");
        }
    }

    private void doSendx(ActiveMQDestination destination, Message jmsMessage, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        ActiveMQMessage activeMQJmsMessage;
        jmsMessage.setJMSDeliveryMode(deliveryMode);
        jmsMessage.setJMSPriority(priority);
        if (timeToLive == 0L) {
            jmsMessage.setJMSExpiration(0L);
        } else {
            jmsMessage.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        if (!this.disableMessageTimestamp) {
            jmsMessage.setJMSTimestamp(System.currentTimeMillis());
        } else {
            jmsMessage.setJMSTimestamp(0L);
        }
        SimpleString address = null;
        ClientSession clientSession = this.session.getCoreSession();
        if (destination == null) {
            if (this.defaultDestination == null) {
                throw new UnsupportedOperationException("Destination must be specified on send with an anonymous producer");
            }
            destination = this.defaultDestination;
        } else {
            if (this.defaultDestination != null && !destination.equals(this.defaultDestination)) {
                throw new UnsupportedOperationException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
            }
            this.session.checkDestination(destination);
            address = destination.getSimpleAddress();
        }
        boolean foreign = false;
        if (!(jmsMessage instanceof ActiveMQMessage)) {
            if (jmsMessage instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)jmsMessage;
                activeMQJmsMessage = new ActiveMQBytesMessage(bytesMessage, clientSession);
            } else if (jmsMessage instanceof MapMessage) {
                MapMessage mapMessage = (MapMessage)jmsMessage;
                activeMQJmsMessage = new ActiveMQMapMessage(mapMessage, clientSession);
            } else if (jmsMessage instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)jmsMessage;
                activeMQJmsMessage = new ActiveMQObjectMessage(objectMessage, clientSession, this.options);
            } else if (jmsMessage instanceof StreamMessage) {
                StreamMessage streamMessage = (StreamMessage)jmsMessage;
                activeMQJmsMessage = new ActiveMQStreamMessage(streamMessage, clientSession);
            } else if (jmsMessage instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)jmsMessage;
                activeMQJmsMessage = new ActiveMQTextMessage(textMessage, clientSession);
            } else {
                activeMQJmsMessage = new ActiveMQMessage(jmsMessage, clientSession);
            }
            jmsMessage.setJMSDestination((Destination)destination);
            foreign = true;
        } else {
            activeMQJmsMessage = (ActiveMQMessage)jmsMessage;
        }
        if (!this.disableMessageID) {
            UUID uid = UUIDGenerator.getInstance().generateUUID();
            activeMQJmsMessage.getCoreMessage().setUserID((Object)uid);
            activeMQJmsMessage.resetMessageID(null);
        }
        if (foreign) {
            jmsMessage.setJMSMessageID(activeMQJmsMessage.getJMSMessageID());
        }
        activeMQJmsMessage.setJMSDestination(destination);
        try {
            activeMQJmsMessage.doBeforeSend();
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.initCause((Throwable)e);
            throw je;
        }
        if (this.defaultDeliveryDelay > 0L) {
            activeMQJmsMessage.setJMSDeliveryTime(System.currentTimeMillis() + this.defaultDeliveryDelay);
        }
        ClientMessage coreMessage = activeMQJmsMessage.getCoreMessage();
        coreMessage.putStringProperty(ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME, this.connID);
        coreMessage.setRoutingType(destination.isQueue() ? RoutingType.ANYCAST : RoutingType.MULTICAST);
        try {
            if (completionListener != null) {
                this.clientProducer.send(address, (org.apache.activemq.artemis.api.core.Message)coreMessage, (SendAcknowledgementHandler)new CompletionListenerWrapper(completionListener, jmsMessage, this));
            } else {
                this.clientProducer.send(address, (org.apache.activemq.artemis.api.core.Message)coreMessage);
            }
        }
        catch (ActiveMQInterruptedException e) {
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        catch (IllegalStateException e) {
            jakarta.jms.IllegalStateException je = new jakarta.jms.IllegalStateException(e.getMessage());
            je.setStackTrace(e.getStackTrace());
            je.initCause((Throwable)e);
            throw je;
        }
    }

    private void checkClosed() throws JMSException {
        if (this.clientProducer.isClosed()) {
            throw new jakarta.jms.IllegalStateException("Producer is closed");
        }
        this.session.checkClosed();
    }

    private static final class CompletionListenerWrapper
    implements SendAcknowledgementHandler {
        private final CompletionListener completionListener;
        private final Message jmsMessage;
        private final ActiveMQMessageProducer producer;

        private CompletionListenerWrapper(CompletionListener listener, Message jmsMessage, ActiveMQMessageProducer producer) {
            this.completionListener = listener;
            this.jmsMessage = jmsMessage;
            this.producer = producer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendAcknowledged(org.apache.activemq.artemis.api.core.Message clientMessage) {
            Message e2;
            Message message = this.jmsMessage;
            if (message instanceof StreamMessage) {
                StreamMessage streamMessage = (StreamMessage)message;
                try {
                    streamMessage.reset();
                }
                catch (JMSException e2) {
                    logger.debug("ignoring exception", (Throwable)e2);
                }
            }
            if ((e2 = this.jmsMessage) instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)e2;
                try {
                    bytesMessage.reset();
                }
                catch (JMSException e3) {
                    logger.debug("ignoring exception", (Throwable)e3);
                }
            }
            try {
                this.producer.connection.getThreadAwareContext().setCurrentThread(true);
                this.completionListener.onCompletion(this.jmsMessage);
            }
            finally {
                this.producer.connection.getThreadAwareContext().clearCurrentThread(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendFailed(org.apache.activemq.artemis.api.core.Message clientMessage, Exception exception) {
            Message message = this.jmsMessage;
            if (message instanceof StreamMessage) {
                StreamMessage streamMessage = (StreamMessage)message;
                try {
                    streamMessage.reset();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            if ((message = this.jmsMessage) instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                try {
                    bytesMessage.reset();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            try {
                this.producer.connection.getThreadAwareContext().setCurrentThread(true);
                if (exception instanceof ActiveMQException) {
                    ActiveMQException activeMQException = (ActiveMQException)exception;
                    exception = JMSExceptionHelper.convertFromActiveMQException(activeMQException);
                } else if (exception instanceof ActiveMQInterruptedException) {
                    ActiveMQInterruptedException activeMQInterruptedException = (ActiveMQInterruptedException)exception;
                    exception = JMSExceptionHelper.convertFromActiveMQException(activeMQInterruptedException);
                }
                this.completionListener.onException(this.jmsMessage, (Exception)exception);
            }
            finally {
                this.producer.connection.getThreadAwareContext().clearCurrentThread(true);
            }
        }

        public String toString() {
            return CompletionListenerWrapper.class.getSimpleName() + "( completionListener=" + String.valueOf(this.completionListener) + ")";
        }
    }
}

