/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActiveMQScheduledComponent
implements ActiveMQComponent,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ScheduledExecutorService scheduledExecutorService;
    private boolean startedOwnScheduler;
    private long initialDelay;
    private long period;
    private TimeUnit timeUnit;
    protected final Executor executor;
    private volatile boolean isStarted;
    private ScheduledFuture future;
    private final boolean onDemand;
    private AtomicBoolean bookedForRunning;

    public ActiveMQScheduledComponent(ScheduledExecutorService scheduledExecutorService, Executor executor, long initialDelay, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
        this.executor = executor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.initialDelay = initialDelay;
        this.period = checkPeriod;
        this.timeUnit = timeUnit;
        this.onDemand = onDemand;
        this.bookedForRunning = new AtomicBoolean(false);
        this.isStarted = false;
    }

    public ActiveMQScheduledComponent(ScheduledExecutorService scheduledExecutorService, long initialDelay, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
        this(scheduledExecutorService, null, initialDelay, checkPeriod, timeUnit, onDemand);
    }

    public ActiveMQScheduledComponent(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
        this(scheduledExecutorService, executor, -1L, checkPeriod, timeUnit, onDemand);
    }

    public ActiveMQScheduledComponent(long initialDelay, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
        this(null, null, initialDelay, checkPeriod, timeUnit, onDemand);
    }

    public ActiveMQScheduledComponent(long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
        this(null, null, checkPeriod, checkPeriod, timeUnit, onDemand);
    }

    @Override
    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, this.getThreadFactory());
            this.startedOwnScheduler = true;
        }
        if (this.onDemand) {
            return;
        }
        if (this.period >= 0L) {
            AtomicBoolean booked = this.bookedForRunning;
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.runForScheduler(booked), this.initialDelay >= 0L ? this.initialDelay : this.period, this.period, this.timeUnit);
        } else {
            logger.trace("did not start scheduled executor on {} because period was configured as {}", (Object)this, (Object)this.period);
        }
    }

    protected ActiveMQThreadFactory getThreadFactory() {
        return new ActiveMQThreadFactory(this.getClass().getSimpleName() + "-scheduled", false, this.getThisClassLoader());
    }

    private ClassLoader getThisClassLoader() {
        return SecurityManagerShim.doPrivileged(() -> this.getClass().getClassLoader());
    }

    public boolean delay() {
        AtomicBoolean booked = this.bookedForRunning;
        if (!booked.compareAndSet(false, true)) {
            return false;
        }
        try {
            this.scheduledExecutorService.schedule(() -> this.bookedRunForScheduler(booked), this.period, this.timeUnit);
            return true;
        }
        catch (RejectedExecutionException e) {
            booked.set(false);
            throw e;
        }
    }

    public long getPeriod() {
        return this.period;
    }

    public synchronized ActiveMQScheduledComponent setPeriod(long period) {
        if (this.period != period) {
            this.period = period;
            this.restartIfNeeded();
        }
        return this;
    }

    public synchronized ActiveMQScheduledComponent setPeriod(long period, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit is required");
        if (this.period != period || this.timeUnit != unit) {
            this.period = period;
            this.timeUnit = unit;
            this.restartIfNeeded();
        }
        return this;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public synchronized ActiveMQScheduledComponent setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
        this.restartIfNeeded();
        return this;
    }

    public synchronized ActiveMQScheduledComponent setInitialDelayAndPeriod(long initialDelay, long period) {
        this.period = period;
        this.initialDelay = initialDelay;
        this.restartIfNeeded();
        return this;
    }

    public synchronized ActiveMQScheduledComponent setInitialDelayAndPeriod(long initialDelay, long period, TimeUnit timeUnit) {
        this.period = period;
        this.initialDelay = initialDelay;
        this.timeUnit = timeUnit;
        this.restartIfNeeded();
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public synchronized ActiveMQScheduledComponent setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.restartIfNeeded();
        return this;
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        this.bookedForRunning = new AtomicBoolean(false);
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        if (this.startedOwnScheduler) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
            this.startedOwnScheduler = false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    private void restartIfNeeded() {
        if (this.isStarted()) {
            this.stop();
            this.start();
        }
    }

    private void runForExecutor(AtomicBoolean booked) {
        boolean alwaysTrue = booked.compareAndSet(true, false);
        assert (alwaysTrue);
        this.run();
    }

    private void bookedRunForScheduler(AtomicBoolean booked) {
        assert (booked.get());
        if (this.executor != null) {
            try {
                this.executor.execute(() -> this.runForExecutor(booked));
            }
            catch (RejectedExecutionException e) {
                if (booked != null) {
                    booked.set(false);
                }
                throw e;
            }
        } else {
            this.runForExecutor(booked);
        }
    }

    private void runForScheduler(AtomicBoolean booked) {
        if (!booked.compareAndSet(false, true)) {
            return;
        }
        this.bookedRunForScheduler(booked);
    }
}

