/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;

@ThreadSafe
public class TLSSocketFactory
implements LayeredConnectionSocketFactory {
    @Nonnull
    @NotEmpty
    public static final String CONTEXT_KEY_TLS_PROTOCOLS = "javasupport.TLSProtocols";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT_KEY_TLS_CIPHER_SUITES = "javasupport.TLSCipherSuites";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT_KEY_HOSTNAME_VERIFIER = "javasupport.HostnameVerifier";
    @Nonnull
    @NotEmpty
    public static final String TLS = "TLS";
    @Nonnull
    @NotEmpty
    public static final String SSL = "SSL";
    @Nonnull
    @NotEmpty
    public static final String SSLV2 = "SSLv2";
    @Nonnull
    public static final HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new NoopHostnameVerifier();
    @Nonnull
    public static final HostnameVerifier STRICT_HOSTNAME_VERIFIER = new DefaultHostnameVerifier();
    @Nonnull
    public static final String[] DEFAULT_ENABLED_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TLSSocketFactory.class);
    @Nonnull
    private final SSLSocketFactory socketfactory;
    @Nonnull
    private final HostnameVerifier hostnameVerifier;
    @Nullable
    private final String[] supportedProtocols;
    @Nullable
    private final String[] supportedCipherSuites;

    public TLSSocketFactory(@Nonnull SSLContext sslContext) {
        this(sslContext, STRICT_HOSTNAME_VERIFIER);
    }

    public TLSSocketFactory(@Nonnull SSLContext sslContext, @Nullable HostnameVerifier verifier) {
        this(((SSLContext)Constraint.isNotNull((Object)sslContext, (String)"SSL context cannot be null")).getSocketFactory(), null, null, verifier);
    }

    public TLSSocketFactory(@Nonnull SSLContext sslContext, @Nullable String[] protocols, @Nullable String[] cipherSuites, @Nullable HostnameVerifier verifier) {
        this(((SSLContext)Constraint.isNotNull((Object)sslContext, (String)"SSL context cannot be null")).getSocketFactory(), protocols, cipherSuites, verifier);
    }

    public TLSSocketFactory(@Nonnull SSLSocketFactory factory, @Nullable HostnameVerifier verifier) {
        this(factory, null, null, verifier);
    }

    public TLSSocketFactory(@Nonnull SSLSocketFactory factory, @Nullable String[] protocols, @Nullable String[] cipherSuites, @Nullable HostnameVerifier verifier) {
        this.socketfactory = (SSLSocketFactory)Constraint.isNotNull((Object)factory, (String)"SSL socket factory cannot be null");
        this.supportedProtocols = protocols;
        this.supportedCipherSuites = cipherSuites;
        this.hostnameVerifier = verifier != null ? verifier : STRICT_HOSTNAME_VERIFIER;
    }

    @Nonnull
    protected SSLSocketFactory getSocketfactory() {
        return this.socketfactory;
    }

    @Nonnull
    protected HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Nullable
    protected String[] getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @Nullable
    protected String[] getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    protected void prepareSocket(@Nonnull SSLSocket socket, @Nullable HttpContext context) throws IOException {
    }

    @Nonnull
    public Socket createSocket(@Nullable HttpContext context) throws IOException {
        this.log.trace("In createSocket");
        return SocketFactory.getDefault().createSocket();
    }

    public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket sock;
        this.log.trace("In connectSocket");
        Args.notNull((Object)host, (String)"HTTP host");
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            int connectTimeoutMillis = connectTimeout.toMillisecondsIntBound();
            if (connectTimeoutMillis > 0 && sock.getSoTimeout() == 0) {
                sock.setSoTimeout(connectTimeoutMillis);
            }
            sock.connect(remoteAddress, connectTimeoutMillis);
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            SSLSocket sslsock = (SSLSocket)sock;
            sslsock.startHandshake();
            this.verifyHostname(sslsock, host.getHostName(), context);
            return sock;
        }
        return this.createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        this.log.trace("In createLayeredSocket");
        SSLSocket sslsock = (SSLSocket)this.getSocketfactory().createSocket(socket, target, port, true);
        String[] contextProtocols = this.getListAttribute(context, CONTEXT_KEY_TLS_PROTOCOLS);
        if (contextProtocols != null) {
            sslsock.setEnabledProtocols(contextProtocols);
        } else if (this.getSupportedProtocols() != null) {
            sslsock.setEnabledProtocols(this.getSupportedProtocols());
        } else {
            sslsock.setEnabledProtocols(DEFAULT_ENABLED_PROTOCOLS);
        }
        String[] contextCipherSuites = this.getListAttribute(context, CONTEXT_KEY_TLS_CIPHER_SUITES);
        if (contextCipherSuites != null) {
            sslsock.setEnabledCipherSuites(contextCipherSuites);
        } else if (this.getSupportedCipherSuites() != null) {
            sslsock.setEnabledCipherSuites(this.getSupportedCipherSuites());
        }
        this.prepareSocket(sslsock, context);
        sslsock.startHandshake();
        this.logSocketInfo(sslsock);
        this.verifyHostname(sslsock, target, context);
        return sslsock;
    }

    private void logSocketInfo(@Nonnull SSLSocket socket) {
        SSLSession session = socket.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connected to: {}", (Object)socket.getRemoteSocketAddress());
            this.log.debug("Supported protocols: {}", (Object)socket.getSupportedProtocols());
            this.log.debug("Enabled protocols:   {}", (Object)socket.getEnabledProtocols());
            this.log.debug("Selected protocol:   {}", (Object)session.getProtocol());
            this.log.debug("Supported cipher suites: {}", (Object)socket.getSupportedCipherSuites());
            this.log.debug("Enabled cipher suites:   {}", (Object)socket.getEnabledCipherSuites());
            this.log.debug("Selected cipher suite:   {}", (Object)session.getCipherSuite());
        }
        if (this.log.isTraceEnabled()) {
            try {
                this.log.trace("Peer principal: {}", (Object)session.getPeerPrincipal());
                this.log.trace("Peer certificates: {}", (Object)session.getPeerCertificates());
                this.log.trace("Local principal: {}", (Object)session.getLocalPrincipal());
                this.log.trace("Local certificates: {}", (Object)session.getLocalCertificates());
            }
            catch (SSLPeerUnverifiedException e) {
                this.log.warn("SSL exception enumerating peer certificates", (Throwable)e);
            }
        }
    }

    @Nullable
    protected String[] getListAttribute(@Nullable HttpContext context, @Nonnull String contextKey) {
        if (context == null) {
            return null;
        }
        ArrayList values = new ArrayList(StringSupport.normalizeStringCollection((Collection)((List)context.getAttribute(contextKey))));
        if (values != null && !values.isEmpty()) {
            return values.toArray(new String[values.size()]);
        }
        return null;
    }

    protected void verifyHostname(@Nonnull SSLSocket sslsock, @Nonnull String hostname, @Nullable HttpContext context) throws IOException {
        HostnameVerifier verifier = null;
        if (context != null) {
            verifier = (HostnameVerifier)context.getAttribute(CONTEXT_KEY_HOSTNAME_VERIFIER);
        }
        if (verifier == null) {
            verifier = this.getHostnameVerifier();
        }
        if (!verifier.verify(hostname, sslsock.getSession())) {
            throw new SSLPeerUnverifiedException("TLS hostname verification failed for hostname: " + hostname);
        }
    }
}

