/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.logging.Level;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.AbstractServiceProviderFilter;
import org.apache.cxf.rs.security.saml.sso.SamlRequestInfo;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.algorithms.JCEMapper;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlRedirectBindingFilter
extends AbstractServiceProviderFilter {
    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        if (this.checkSecurityContext(m)) {
            return;
        }
        try {
            SamlRequestInfo info = this.createSamlRequestInfo(m);
            String urlEncodedRequest = URLEncoder.encode(info.getSamlRequest(), StandardCharsets.UTF_8.name());
            UriBuilder ub = UriBuilder.fromUri((String)this.getIdpServiceAddress());
            ub.queryParam("SAMLRequest", new Object[]{urlEncodedRequest});
            ub.queryParam("RelayState", new Object[]{info.getRelayState()});
            if (this.isSignRequest()) {
                this.signRequest(urlEncodedRequest, info.getRelayState(), ub);
            }
            String contextCookie = this.createCookie("RelayState", info.getRelayState(), info.getWebAppContext(), info.getWebAppDomain());
            context.abortWith(Response.seeOther((URI)ub.build(new Object[0])).header("Cache-Control", (Object)"no-cache, no-store").header("Pragma", (Object)"no-cache").header("Set-Cookie", (Object)contextCookie).build());
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, ex.getMessage(), ex);
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
    }

    @Override
    protected void signAuthnRequest(AuthnRequest authnRequest) throws Exception {
    }

    @Override
    protected String encodeAuthnRequest(Element authnRequest) throws IOException {
        String requestMessage = DOM2Writer.nodeToString((Node)authnRequest);
        DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
        byte[] deflatedBytes = encoder.deflateToken(requestMessage.getBytes(StandardCharsets.UTF_8));
        return Base64Utility.encode((byte[])deflatedBytes);
    }

    private void signRequest(String authnRequest, String relayState, UriBuilder ub) throws Exception {
        Crypto crypto = this.getSignatureCrypto();
        if (crypto == null) {
            LOG.warning("No crypto instance of properties file configured for signature");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        String signatureUser = this.getSignatureUsername();
        if (signatureUser == null) {
            LOG.warning("No user configured for signature");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        CallbackHandler callbackHandler = this.getCallbackHandler();
        if (callbackHandler == null) {
            LOG.warning("No CallbackHandler configured to supply a password for signature");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(signatureUser);
        X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
        if (issuerCerts == null) {
            throw new Exception("No issuer certs were found to sign the request using name: " + signatureUser);
        }
        String sigAlgo = this.getSignatureAlgorithm();
        String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
        LOG.fine("automatic sig algo detection: " + pubKeyAlgo);
        if ("DSA".equalsIgnoreCase(pubKeyAlgo)) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        LOG.fine("Using Signature algorithm " + sigAlgo);
        ub.queryParam("SigAlg", new Object[]{URLEncoder.encode(sigAlgo, StandardCharsets.UTF_8.name())});
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(signatureUser, 3)};
        callbackHandler.handle((Callback[])cb);
        String password = cb[0].getPassword();
        PrivateKey privateKey = crypto.getPrivateKey(signatureUser, password);
        String jceSigAlgo = JCEMapper.translateURItoJCEID((String)sigAlgo);
        Signature signature = Signature.getInstance(jceSigAlgo);
        signature.initSign(privateKey);
        String requestToSign = "SAMLRequest=" + authnRequest + "&" + "RelayState" + "=" + relayState + "&" + "SigAlg" + "=" + URLEncoder.encode(sigAlgo, StandardCharsets.UTF_8.name());
        signature.update(requestToSign.getBytes(StandardCharsets.UTF_8));
        byte[] signBytes = signature.sign();
        String encodedSignature = Base64.getEncoder().encodeToString(signBytes);
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
        ub.queryParam("Signature", new Object[]{URLEncoder.encode(encodedSignature, StandardCharsets.UTF_8.name())});
    }
}

