/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;
import org.junit.platform.engine.discovery.NestedMethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

@API(status=API.Status.STABLE, since="1.10")
public interface SelectorResolver {
    default public Resolution resolve(ClasspathResourceSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(ClasspathRootSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(ClassSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(NestedClassSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(DirectorySelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(FileSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(MethodSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(NestedMethodSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(ModuleSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(PackageSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(UniqueIdSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(UriSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.9")
    default public Resolution resolve(IterationSelector selector, Context context) {
        return this.resolve((DiscoverySelector)selector, context);
    }

    default public Resolution resolve(DiscoverySelector selector, Context context) {
        return Resolution.unresolved();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static interface Context {
        public Optional<TestDescriptor> resolve(DiscoverySelector var1);

        public <T extends TestDescriptor> Optional<T> addToParent(Function<TestDescriptor, Optional<T>> var1);

        public <T extends TestDescriptor> Optional<T> addToParent(Supplier<DiscoverySelector> var1, Function<TestDescriptor, Optional<T>> var2);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static class Resolution {
        private static final Resolution UNRESOLVED = new Resolution(Collections.emptySet(), Collections.emptySet());
        private final Set<Match> matches;
        private final Set<? extends DiscoverySelector> selectors;

        public static Resolution unresolved() {
            return UNRESOLVED;
        }

        public static Resolution match(Match match) {
            return new Resolution(Collections.singleton(match), Collections.emptySet());
        }

        public static Resolution matches(Set<Match> matches) {
            Preconditions.containsNoNullElements(matches, "matches must not contain null elements");
            Preconditions.notEmpty(matches, "matches must not be empty");
            return new Resolution(matches, Collections.emptySet());
        }

        public static Resolution selectors(Set<? extends DiscoverySelector> selectors) {
            Preconditions.containsNoNullElements(selectors, "selectors must not contain null elements");
            Preconditions.notEmpty(selectors, "selectors must not be empty");
            return new Resolution(Collections.emptySet(), selectors);
        }

        private Resolution(Set<Match> matches, Set<? extends DiscoverySelector> selectors) {
            this.matches = matches;
            this.selectors = selectors;
        }

        public boolean isResolved() {
            return this != UNRESOLVED;
        }

        public Set<Match> getMatches() {
            return this.matches;
        }

        public Set<? extends DiscoverySelector> getSelectors() {
            return this.selectors;
        }
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static class Match {
        private final TestDescriptor testDescriptor;
        private final Supplier<Set<? extends DiscoverySelector>> childSelectorsSupplier;
        private final Type type;

        public static Match exact(TestDescriptor testDescriptor) {
            return Match.exact(testDescriptor, Collections::emptySet);
        }

        public static Match exact(TestDescriptor testDescriptor, Supplier<Set<? extends DiscoverySelector>> childSelectorsSupplier) {
            return new Match(testDescriptor, childSelectorsSupplier, Type.EXACT);
        }

        public static Match partial(TestDescriptor testDescriptor) {
            return Match.partial(testDescriptor, Collections::emptySet);
        }

        public static Match partial(TestDescriptor testDescriptor, Supplier<Set<? extends DiscoverySelector>> childSelectorsSupplier) {
            return new Match(testDescriptor, childSelectorsSupplier, Type.PARTIAL);
        }

        private Match(TestDescriptor testDescriptor, Supplier<Set<? extends DiscoverySelector>> childSelectorsSupplier, Type type) {
            this.testDescriptor = Preconditions.notNull(testDescriptor, "testDescriptor must not be null");
            this.childSelectorsSupplier = Preconditions.notNull(childSelectorsSupplier, "childSelectorsSupplier must not be null");
            this.type = type;
        }

        public boolean isExact() {
            return this.type == Type.EXACT;
        }

        public TestDescriptor getTestDescriptor() {
            return this.testDescriptor;
        }

        public Set<? extends DiscoverySelector> expand() {
            return this.childSelectorsSupplier.get();
        }

        private static enum Type {
            EXACT,
            PARTIAL;

        }
    }
}

