/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.interpolation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.core.FieldElement;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathArithmeticException;
import org.apache.commons.math4.legacy.exception.NoDataException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.ZeroException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;

public class FieldHermiteInterpolator<T extends FieldElement<T>> {
    private final List<T> abscissae = new ArrayList<T>();
    private final List<T[]> topDiagonal = new ArrayList<T[]>();
    private final List<T[]> bottomDiagonal = new ArrayList<T[]>();

    @SafeVarargs
    public final void addSamplePoint(T x, T[] ... value) throws ZeroException, MathArithmeticException, DimensionMismatchException, NullArgumentException {
        NullArgumentException.check(x);
        FieldElement factorial = (FieldElement)x.getField().getOne();
        for (int i = 0; i < value.length; ++i) {
            FieldElement[] y = (FieldElement[])value[i].clone();
            if (i > 1) {
                factorial = (FieldElement)factorial.multiply(i);
                FieldElement inv = (FieldElement)factorial.reciprocal();
                for (int j = 0; j < y.length; ++j) {
                    y[j] = (FieldElement)y[j].multiply((Object)inv);
                }
            }
            int n = this.abscissae.size();
            this.bottomDiagonal.add(n - i, y);
            FieldElement[] bottom0 = y;
            for (int j = i; j < n; ++j) {
                FieldElement[] bottom1 = (FieldElement[])this.bottomDiagonal.get(n - (j + 1));
                if (x.equals(this.abscissae.get(n - (j + 1)))) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, new Object[]{x});
                }
                FieldElement inv = (FieldElement)((FieldElement)x.subtract((Object)((FieldElement)this.abscissae.get(n - (j + 1))))).reciprocal();
                for (int k = 0; k < y.length; ++k) {
                    bottom1[k] = (FieldElement)inv.multiply((Object)((FieldElement)bottom0[k].subtract((Object)bottom1[k])));
                }
                bottom0 = bottom1;
            }
            this.topDiagonal.add((FieldElement[])bottom0.clone());
            this.abscissae.add(x);
        }
    }

    public T[] value(T x) throws NoDataException, NullArgumentException {
        NullArgumentException.check(x);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException((Localizable)LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement[] value = (FieldElement[])MathArrays.buildArray((Field)x.getField(), (int)((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement valueCoeff = (FieldElement)x.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            FieldElement[] dividedDifference = (FieldElement[])this.topDiagonal.get(i);
            for (int k = 0; k < value.length; ++k) {
                value[k] = (FieldElement)value[k].add((Object)((FieldElement)dividedDifference[k].multiply((Object)valueCoeff)));
            }
            FieldElement deltaX = (FieldElement)x.subtract((Object)((FieldElement)this.abscissae.get(i)));
            valueCoeff = (FieldElement)valueCoeff.multiply((Object)deltaX);
        }
        return value;
    }

    public T[][] derivatives(T x, int order) throws NoDataException, NullArgumentException {
        NullArgumentException.check(x);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException((Localizable)LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement zero = (FieldElement)x.getField().getZero();
        FieldElement one = (FieldElement)x.getField().getOne();
        FieldElement[] tj = (FieldElement[])MathArrays.buildArray((Field)x.getField(), (int)(order + 1));
        tj[0] = zero;
        for (int i = 0; i < order; ++i) {
            tj[i + 1] = (FieldElement)tj[i].add((Object)one);
        }
        FieldElement[][] derivatives = (FieldElement[][])MathArrays.buildArray((Field)x.getField(), (int)(order + 1), (int)((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement[] valueCoeff = (FieldElement[])MathArrays.buildArray((Field)x.getField(), (int)(order + 1));
        valueCoeff[0] = (FieldElement)x.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            FieldElement[] dividedDifference = (FieldElement[])this.topDiagonal.get(i);
            FieldElement deltaX = (FieldElement)x.subtract((Object)((FieldElement)this.abscissae.get(i)));
            for (int j = order; j >= 0; --j) {
                for (int k = 0; k < derivatives[j].length; ++k) {
                    derivatives[j][k] = (FieldElement)derivatives[j][k].add((Object)((FieldElement)dividedDifference[k].multiply((Object)valueCoeff[j])));
                }
                valueCoeff[j] = (FieldElement)valueCoeff[j].multiply((Object)deltaX);
                if (j <= 0) continue;
                valueCoeff[j] = (FieldElement)valueCoeff[j].add((Object)((FieldElement)tj[j].multiply((Object)valueCoeff[j - 1])));
            }
        }
        return derivatives;
    }
}

