/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractOrigin;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public abstract class AbstractOriginTest<T, B extends AbstractOrigin<T, B>> {
    protected static final String FILE_RES_RO = "/org/apache/commons/io/test-file-20byteslength.bin";
    protected static final String FILE_NAME_RO = "src/test/resources/org/apache/commons/io/test-file-20byteslength.bin";
    protected static final String FILE_NAME_RW = AbstractOriginTest.class.getSimpleName() + ".txt";
    private static final int RO_LENGTH = 20;
    protected AbstractOrigin<T, B> originRo;
    protected AbstractOrigin<T, B> originRw;
    @TempDir
    protected Path tempPath;

    @BeforeEach
    void beforeEach() throws IOException {
        this.setOriginRo((AbstractOrigin<T, B>)this.newOriginRo());
        this.resetOriginRw();
        this.setOriginRw((AbstractOrigin<T, B>)this.newOriginRw());
    }

    private void checkRead(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(20);
        int read = channel.read(buffer);
        Assertions.assertEquals((int)20, (int)read);
        Assertions.assertArrayEquals((byte[])this.getFixtureByteArray(), (byte[])buffer.array());
        buffer.clear();
        read = channel.read(buffer);
        Assertions.assertEquals((int)-1, (int)read);
    }

    private void checkWrite(WritableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(this.getFixtureByteArray());
        int written = channel.write(buffer);
        Assertions.assertEquals((int)20, (int)written);
    }

    @AfterEach
    void cleanup() {
        Object originRw;
        Object originRo = this.getOriginRo().get();
        if (originRo instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)originRo));
        }
        if ((originRw = this.getOriginRw().get()) instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)originRw));
        }
    }

    byte[] getFixtureByteArray() throws IOException {
        return IOUtils.resourceToByteArray((String)FILE_RES_RO);
    }

    String getFixtureString() throws IOException {
        return IOUtils.resourceToString((String)FILE_RES_RO, (Charset)StandardCharsets.UTF_8);
    }

    protected AbstractOrigin<T, B> getOriginRo() {
        return Objects.requireNonNull(this.originRo, "originRo");
    }

    protected AbstractOrigin<T, B> getOriginRw() {
        return Objects.requireNonNull(this.originRw, "originRw");
    }

    private boolean isValid(RandomAccessFile raf) throws IOException {
        return Objects.requireNonNull(raf).getFD().valid();
    }

    protected abstract B newOriginRo() throws IOException;

    protected abstract B newOriginRw() throws IOException;

    protected void resetOriginRw() throws IOException {
    }

    protected void setOriginRo(AbstractOrigin<T, B> origin) {
        this.originRo = origin;
    }

    protected void setOriginRw(AbstractOrigin<T, B> origin) {
        this.originRw = origin;
    }

    @Test
    void testGetByteArray() throws IOException {
        Assertions.assertArrayEquals((byte[])this.getFixtureByteArray(), (byte[])this.getOriginRo().getByteArray());
    }

    @Test
    void testGetByteArrayAt_0_0() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.getOriginRo().getByteArray(0L, 0));
    }

    @Test
    void testGetByteArrayAt_0_1() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[]{49}, (byte[])this.getOriginRo().getByteArray(0L, 1));
    }

    @Test
    void testGetByteArrayAt_1_1() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[]{50}, (byte[])this.getOriginRo().getByteArray(1L, 1));
    }

    @Test
    void testGetCharSequence() throws IOException {
        CharSequence charSequence = this.getOriginRo().getCharSequence(StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)charSequence);
        Assertions.assertEquals((Object)this.getFixtureString(), (Object)charSequence.toString());
    }

    @Test
    void testGetFile() throws IOException {
        this.testGetFile(this.getOriginRo().getFile(), 20L);
        FileUtils.touch((File)this.getOriginRw().getFile());
        this.testGetFile(this.getOriginRw().getFile(), 0L);
    }

    private void testGetFile(File file, long expectedLen) throws IOException {
        Assertions.assertNotNull((Object)file);
        Assertions.assertTrue((boolean)file.exists(), () -> "File does not exist: " + file);
        int length = FileUtils.readFileToByteArray((File)file).length;
        Assertions.assertEquals((long)length, (long)expectedLen, () -> String.format("File %s, actual length=%,d", file, length));
    }

    @Test
    void testGetInputStream() throws IOException {
        try (InputStream inputStream = this.getOriginRo().getInputStream(new OpenOption[0]);){
            Assertions.assertNotNull((Object)inputStream);
            Assertions.assertArrayEquals((byte[])this.getFixtureByteArray(), (byte[])IOUtils.toByteArray((InputStream)inputStream));
        }
    }

    @Test
    void testGetOutputStream() throws IOException {
        try (OutputStream output = this.getOriginRw().getOutputStream(new OpenOption[0]);){
            Assertions.assertNotNull((Object)output);
        }
    }

    @Test
    void testGetPath() throws IOException {
        this.testGetPath(this.getOriginRo().getPath(), 20L);
        FileUtils.touch((File)this.getOriginRw().getPath().toFile());
        this.testGetPath(this.getOriginRw().getPath(), 0L);
    }

    private void testGetPath(Path path, long expectedLen) throws IOException {
        Assertions.assertNotNull((Object)path);
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        int length = Files.readAllBytes(path).length;
        Assertions.assertEquals((long)length, (long)expectedLen, () -> String.format("Path %s, actual length=%,d", path, length));
    }

    @Test
    void testGetRandomAccessFile() throws IOException {
        try (RandomAccessFile raf = this.getOriginRo().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertTrue((boolean)this.isValid(raf));
        }
        boolean isRafOriginRo = this.getOriginRo() instanceof AbstractOrigin.RandomAccessFileOrigin;
        boolean isRafOriginRw = this.getOriginRw() instanceof AbstractOrigin.RandomAccessFileOrigin;
        try (RandomAccessFile raf = this.getOriginRo().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOriginRo && this.isValid(raf) ? 1 : 0) != 0);
        }
        raf = this.getOriginRo().getRandomAccessFile(new OpenOption[]{StandardOpenOption.READ});
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOriginRo && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = this.getOriginRw().getRandomAccessFile(new OpenOption[]{StandardOpenOption.WRITE});
        try {
            Assertions.assertNotNull((Object)raf);
            if (isRafOriginRw || this.getOriginRw().getFile() != null) {
                Assertions.assertTrue((boolean)this.isValid(raf), () -> this.getOriginRw().toString());
            } else {
                Assertions.assertFalse((boolean)this.isValid(raf), () -> this.getOriginRw().toString());
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = this.getOriginRw().getRandomAccessFile(new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOriginRw && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=StandardOpenOption.class)
    void testGetRandomAccessFile(OpenOption openOption) throws IOException {
        try (RandomAccessFile raf = this.getOriginRw().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertTrue((boolean)this.isValid(raf));
        }
        boolean isRafOrigin = this.getOriginRw() instanceof AbstractOrigin.RandomAccessFileOrigin;
        try (RandomAccessFile raf = this.getOriginRw().getRandomAccessFile(new OpenOption[0]);){
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOrigin && this.isValid(raf) ? 1 : 0) != 0);
        }
        raf = this.getOriginRw().getRandomAccessFile(new OpenOption[]{openOption});
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOrigin && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = this.getOriginRw().getRandomAccessFile(new OpenOption[]{openOption});
        try {
            Assertions.assertNotNull((Object)raf);
            Assertions.assertFalse((isRafOrigin && this.isValid(raf) ? 1 : 0) != 0);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    @Test
    void testGetReadableByteChannel() throws IOException {
        try (ReadableByteChannel channel = (ReadableByteChannel)this.getOriginRo().getChannel(ReadableByteChannel.class, new OpenOption[]{StandardOpenOption.READ});){
            SeekableByteChannel seekable = channel instanceof SeekableByteChannel ? (SeekableByteChannel)channel : null;
            Assertions.assertNotNull((Object)channel);
            Assertions.assertTrue((boolean)channel.isOpen());
            if (seekable != null) {
                Assertions.assertEquals((long)0L, (long)seekable.position());
                Assertions.assertEquals((long)20L, (long)seekable.size());
            }
            this.checkRead(channel);
            if (seekable != null) {
                Assertions.assertEquals((long)20L, (long)seekable.position());
            }
        }
    }

    @Test
    void testGetReader() throws IOException {
        try (Reader reader = this.getOriginRo().getReader(Charset.defaultCharset());){
            Assertions.assertNotNull((Object)reader);
        }
        this.setOriginRo((AbstractOrigin<T, B>)this.newOriginRo());
        reader = this.getOriginRo().getReader(null);
        try {
            Assertions.assertNotNull((Object)reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.setOriginRo((AbstractOrigin<T, B>)this.newOriginRo());
        reader = this.getOriginRo().getReader(StandardCharsets.UTF_8);
        try {
            Assertions.assertNotNull((Object)reader);
            Assertions.assertEquals((Object)this.getFixtureString(), (Object)IOUtils.toString((Reader)reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    void testGetWritableByteChannel() throws IOException {
        SeekableByteChannel seekable;
        boolean supportsRead;
        try (Channel channel = (WritableByteChannel)this.getOriginRw().getChannel(WritableByteChannel.class, new OpenOption[]{StandardOpenOption.WRITE});){
            supportsRead = channel instanceof ReadableByteChannel;
            seekable = channel instanceof SeekableByteChannel ? (SeekableByteChannel)channel : null;
            Assertions.assertNotNull((Object)channel);
            Assertions.assertTrue((boolean)channel.isOpen());
            if (seekable != null) {
                Assertions.assertEquals((long)0L, (long)seekable.position());
                Assertions.assertEquals((long)0L, (long)seekable.size());
            }
            this.checkWrite((WritableByteChannel)channel);
            if (seekable != null) {
                Assertions.assertEquals((long)20L, (long)seekable.position());
                Assertions.assertEquals((long)20L, (long)seekable.size());
            }
        }
        if (supportsRead) {
            this.setOriginRw((AbstractOrigin<T, B>)this.newOriginRw());
            channel = (ReadableByteChannel)this.getOriginRw().getChannel(ReadableByteChannel.class, new OpenOption[]{StandardOpenOption.READ});
            try {
                Assertions.assertNotNull((Object)channel);
                Assertions.assertTrue((boolean)channel.isOpen());
                this.checkRead((ReadableByteChannel)channel);
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
        this.setOriginRw((AbstractOrigin<T, B>)this.newOriginRw());
        channel = (WritableByteChannel)this.getOriginRw().getChannel(WritableByteChannel.class, new OpenOption[]{StandardOpenOption.WRITE});
        try {
            seekable = channel instanceof SeekableByteChannel ? (SeekableByteChannel)channel : null;
            Assertions.assertNotNull((Object)channel);
            Assertions.assertTrue((boolean)channel.isOpen());
            if (seekable != null) {
                seekable.position(20L);
                Assertions.assertEquals((long)20L, (long)seekable.position());
                Assertions.assertEquals((long)20L, (long)seekable.size());
                int newSize = 10;
                seekable.truncate(10L);
                Assertions.assertEquals((long)10L, (long)seekable.position());
                Assertions.assertEquals((long)10L, (long)seekable.size());
                seekable.position(0L);
                Assertions.assertEquals((long)0L, (long)seekable.position());
            }
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    @Test
    void testGetWriter() throws IOException {
        try (Writer writer = this.getOriginRw().getWriter(Charset.defaultCharset(), new OpenOption[0]);){
            Assertions.assertNotNull((Object)writer);
        }
        this.setOriginRw((AbstractOrigin<T, B>)this.newOriginRw());
        writer = this.getOriginRw().getWriter(null, new OpenOption[0]);
        try {
            Assertions.assertNotNull((Object)writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Test
    void testSize() throws IOException {
        Assertions.assertEquals((int)20, (int)this.getOriginRo().getByteArray().length);
    }
}

